<?php
defined( 'ABSPATH' ) || exit;

/**
 * Feature Box Shortcode.
 *
 * @package TotalThemeCore
 * @version 1.4.5
 */
if ( ! class_exists( 'VCEX_Feature_Box_Shortcode' ) ) {

	class VCEX_Feature_Box_Shortcode {

		/**
		 * Main constructor.
		 */
		public function __construct() {
			add_shortcode( 'vcex_feature_box', array( $this, 'output' ) );

			if ( function_exists( 'vc_lean_map' ) ) {
				TotalThemeCore\WPBakery\Map\Vcex_Feature_Box::instance();
			}

		}

		/**
		 * Shortcode output => Get template file and display shortcode.
		 */
		public function output( $atts, $content = null ) {
			if ( ! vcex_maybe_display_shortcode( 'vcex_feature_box', $atts ) ) {
				return;
			}
			ob_start();
			do_action( 'vcex_shortcode_before', 'vcex_feature_box', $atts );
			include( vcex_get_shortcode_template( 'vcex_feature_box' ) );
			do_action( 'vcex_shortcode_after', 'vcex_feature_box', $atts );
			return ob_get_clean();
		}

		/**
		 * Array of shortcode parameters.
		 */
		public static function get_params() {
			$params = array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Heading', 'total-theme-core' ),
					'param_name' => 'heading',
					'value' => 'Sample Heading',
					'description' => vcex_shortcode_param_description( 'text' ),
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Image', 'total-theme-core' ),
					'param_name' => 'image',
				),
				array(
					'type' => 'textarea_html',
					'holder' => 'div',
					'heading' => esc_html__( 'Content', 'total-theme-core' ),
					'param_name' => 'content',
					'value' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Element ID', 'total-theme-core' ),
					'param_name' => 'unique_id',
					'admin_label' => true,
					'description' => vcex_shortcode_param_description( 'unique_id' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'param_name' => 'classes',
				),
				array(
					'type' => 'vcex_visibility',
					'heading' => esc_html__( 'Visibility', 'total-theme-core' ),
					'param_name' => 'visibility',
				),
				vcex_vc_map_add_css_animation(),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Duration', 'total'),
					'param_name' => 'animation_duration',
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Animation Delay', 'total'),
					'param_name' => 'animation_delay',
					'description' => esc_html__( 'Enter your custom time in seconds (decimals allowed).', 'total'),
				),
				// Style
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Style', 'total-theme-core' ),
					'param_name' => 'style',
					'std' => 'left-content-right-image',
					'choices' => array(
						'left-content-right-image' => esc_html__( 'Right Image', 'total-theme-core' ),
						'left-image-right-content' => esc_html__( 'Left Image', 'total-theme-core' ),
					),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Vertical Align Center', 'total-theme-core' ),
					'param_name' => 'content_vertical_align',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Bottom Margin', 'total-theme-core' ),
					'param_name' => 'bottom_margin',
					'value' => vcex_margin_choices(),
					'admin_label' => true,
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Gap', 'total-theme-core' ),
					'param_name' => 'gap',
					'choices' => 'gap',
					'description' => vcex_shortcode_param_description( 'gap' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Stacked Gap', 'total-theme-core' ),
					'param_name' => 'stack_gap',
					'choices' => 'gap',
					'description' => vcex_shortcode_param_description( 'gap' ),
					'dependency' => array( 'element' => 'stack_bk', 'value_not_equal_to' => 'false' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Shadow', 'total' ),
					'param_name' => 'shadow',
					'value' => vcex_shadow_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Shadow: Hover', 'total' ),
					'param_name' => 'shadow_hover',
					'value' => vcex_shadow_choices(),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_hover_animations',
					'heading' => esc_html__( 'Hover Animation', 'total-theme-core'),
					'param_name' => 'hover_animation',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total-theme-core' ),
					'param_name' => 'background',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_trbl',
					'heading' => esc_html__( 'Padding', 'total-theme-core' ),
					'param_name' => 'padding',
					'description' => vcex_shortcode_param_description( 'padding' ),
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Border', 'total-theme-core' ),
					'description' => esc_html__( 'Please use the shorthand format: width style color. Enter 0px or "none" to disable border.', 'total-theme-core' ),
					'param_name' => 'border',
					'group' => esc_html__( 'Style', 'total-theme-core' ),
				),
				// Widths
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Justify Content', 'total-theme-core' ),
					'param_name' => 'justify',
					'value' => vcex_justify_content_choices(),
					'group' => esc_html__( 'Widths', 'total-theme-core' ),
					'description' => esc_html__( 'Used to adjust the layout when the content and image widths don\'t add up to 100%.', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Content Width', 'total-theme-core' ),
					'param_name' => 'content_width',
					'value' => '50%',
					'description' => esc_html__( 'Allowed:', 'total-theme-core' ) . ' px, rem, vw, vmin, vmax, var, calc, auto, %',
					'group' => esc_html__( 'Widths', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Image Width', 'total-theme-core' ),
					'param_name' => 'media_width',
					'value' => '50%',
					'description' => esc_html__( 'Allowed:', 'total-theme-core' ) . ' px, rem, vw, vmin, vmax, var, calc, auto, %',
					'group' => esc_html__( 'Widths', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Breakpoint', 'total' ),
					'param_name' => 'stack_bk',
					'value' => array(
						esc_html__( 'Default', 'total' ) => '',
						esc_html__( 'sm - 640px', 'total' ) => 'sm',
						esc_html__( 'md - 768px', 'total' ) => 'md',
						esc_html__( 'lg - 1024px', 'total' ) => 'lg',
						esc_html__( 'xl - 1280px', 'total' ) => 'xl',
						esc_html__( 'Do not stack', 'total' ) => 'false',
						esc_html__( 'Custom', 'total' ) => 'custom',
					),
					'description' => esc_html__( 'Select the breakpoint at which point the element will go from a stacked layout to a left/right layout. The default value is 640px (sm) which can be altered by hooking into the "vcex_feature_box_default_breakpoint" filter.', 'total' ),
					'group' => esc_html__( 'Widths', 'total' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom Breakpoint', 'total' ),
					'param_name' => 'custom_stack_bk',
					'description' => vcex_shortcode_param_description( 'px' ),
					'dependency' => array( 'element' => 'stack_bk', 'value' => 'custom' ),
					'group' => esc_html__( 'Widths', 'total' ),
				),
				// Content
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Text Alignment', 'total-theme-core' ),
					'std' => '',
					'param_name' => 'text_align',
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				array(
					'type'  => 'vcex_font_family_select',
					'heading' => esc_html__( 'Font Family', 'total-theme-core' ),
					'param_name' => 'content_font_family',
					'std' => '',
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
					'param_name' => 'content_font_size',
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_font_weight',
					'heading' => esc_html__( 'Font Weight', 'total-theme-core' ),
					'param_name' => 'content_font_weight',
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Background', 'total-theme-core' ),
					'param_name' => 'content_background',
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'content_color',
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_trbl',
					'heading' => esc_html__( 'Padding', 'total-theme-core' ),
					'param_name' => 'content_padding',
					'description' => vcex_shortcode_param_description( 'padding' ),
					'group' => esc_html__( 'Content', 'total-theme-core' ),
				),
				// Heading
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Tag', 'total-theme-core' ),
					'param_name' => 'heading_type',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
					'std' => '',
					'choices' => 'html_tag',
				),
				array(
					'type'  => 'vcex_font_family_select',
					'heading' => esc_html__( 'Font Family', 'total-theme-core' ),
					'param_name' => 'heading_font_family',
					'std' => '',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_colorpicker',
					'heading' => esc_html__( 'Color', 'total-theme-core' ),
					'param_name' => 'heading_color',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_font_size',
					'heading' => esc_html__( 'Font Size', 'total-theme-core' ),
					'param_name' => 'heading_size',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Letter Spacing', 'total-theme-core' ),
					'param_name' => 'heading_letter_spacing',
					'choices' => 'letter_spacing',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_font_weight',
					'heading' => esc_html__( 'Font Weight', 'total-theme-core' ),
					'param_name' => 'heading_weight',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text_transforms',
					'heading' => esc_html__( 'Text Transform', 'total-theme-core' ),
					'param_name' => 'heading_transform',
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_trbl',
					'heading' => esc_html__( 'Margin', 'total-theme-core' ),
					'param_name' => 'heading_margin',
					'description' => vcex_shortcode_param_description( 'margin' ),
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				array(
					'type' => 'vc_link',
					'heading' => esc_html__( 'Link', 'total-theme-core' ),
					'param_name' => 'heading_url',
					'dependency' => array( 'element' => 'onclick_el', 'value_not_equal_to' => 'container' ),
					'description' => esc_html__( 'Note: This is an older setting added before the introduction of the "Link" tab.', 'total-theme-core' ),
					'group' => esc_html__( 'Heading', 'total-theme-core' ),
				),
				// Image
				array(
					'type' => 'vcex_ofswitch',
					'std' => 'false',
					'heading' => esc_html__( 'Stretch Image', 'total-theme-core' ),
					'param_name' => 'equal_heights',
					'description' => esc_html__( 'When enabled the image will strech to fill the column so it will always be at least as tall as the content.', 'total-theme-core' ),
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_text_alignments',
					'heading' => esc_html__( 'Image Alignment', 'total-theme-core' ),
					'std' => '',
					'param_name' => 'media_align',
					'description' => esc_html__( 'Note: When stacked the image will be aligned according to your content aligment for consistency.', 'total-theme-core' ),
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Image Fit', 'total-theme-core' ),
					'param_name' => 'image_object_fit',
					'group' => esc_html__( 'Image', 'total-theme-core' ),
					'stc' => 'cover',
					'value' => array(
						esc_html__( 'Cover', 'total-theme-core' ) => 'cover',
						esc_html__( 'Contain', 'total-theme-core' ) => 'contain',
						esc_html__( 'Fill', 'total-theme-core' ) => 'fill',
						esc_html__( 'Scale Down', 'total-theme-core' ) => 'scale-down',
					),
				),
				array(
					'type' => 'vcex_image_sizes',
					'heading' => esc_html__( 'Image Size', 'total-theme-core' ),
					'param_name' => 'img_size',
					'std' => 'wpex_custom',
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_image_crop_locations',
					'heading' => esc_html__( 'Image Crop Location', 'total-theme-core' ),
					'param_name' => 'img_crop',
					'group' => esc_html__( 'Image', 'total-theme-core' ),
					'dependency' => array( 'element' => 'img_size', 'value' => 'wpex_custom' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Image Width', 'total-theme-core' ),
					'param_name' => 'img_width',
					'description' => esc_html__( 'Enter a width in pixels.', 'total-theme-core' ),
					'group' => esc_html__( 'Image', 'total-theme-core' ),
					'dependency' => array( 'element' => 'img_size', 'value' => 'wpex_custom' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Image Height', 'total-theme-core' ),
					'param_name' => 'img_height',
					'description' => esc_html__( 'Leave empty to disable vertical cropping and keep image proportions.', 'total-theme-core' ),
					'group' => esc_html__( 'Image', 'total-theme-core' ),
					'dependency' => array( 'element' => 'img_size', 'value' => 'wpex_custom' ),
				),
				array(
					'type' => 'vcex_preset_textfield',
					'heading' => esc_html__( 'Border Radius', 'total-theme-core' ),
					'param_name' => 'img_border_radius',
					'choices' => 'border_radius',
					'supports_blobs' => true,
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_image_hovers',
					'heading' => esc_html__( 'CSS3 Image Hover', 'total-theme-core' ),
					'param_name' => 'img_hover_style',
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_image_filters',
					'heading' => esc_html__( 'Image Filter', 'total-theme-core' ),
					'param_name' => 'img_filter',
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'vc_link',
					'heading' => esc_html__( 'Image URL', 'total-theme-core' ),
					'param_name' => 'image_url',
					'description' => esc_html__( 'Note: This is an older setting added before the introduction of the "Link" tab.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'onclick_el', 'value_not_equal_to' => 'container' ),
					'group' => esc_html__( 'Image', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Lightbox Type', 'total-theme-core' ),
					'param_name' => 'image_lightbox',
					'group' => esc_html__( 'Image', 'total-theme-core' ),
					'value' => array(
						esc_html__( 'None', 'total-theme-core' ) => '',
						esc_html__( 'Auto Detect (Image, Video or Inline)', 'total-theme-core' ) => 'auto-detect',
						esc_html__( 'Self', 'total-theme-core' ) => 'image',
						esc_html__( 'URL', 'total-theme-core' ) => 'url',
						esc_html__( 'Video', 'total-theme-core' ) => 'video_embed',
						esc_html__( 'Inline Content', 'total-theme-core' ) => 'inline',
						esc_html__( 'HTML5', 'total-theme-core' ) => 'html5',
					),
					'dependency' => array( 'element' => 'image_url', 'not_empty' => true ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Lightbox Dimensions', 'total-theme-core' ),
					'param_name' => 'lightbox_dimensions',
					'description' => esc_html__( 'Enter a custom width and height for your lightbox pop-up window. Use format widthxheight. Example: 1920x1080.', 'total-theme-core' ),
					'group' => esc_html__( 'Image', 'total-theme-core' ),
					'dependency' => array( 'element' => 'image_lightbox', 'value' => array( 'video_embed', 'url', 'html5', 'iframe' ) ),
				),
				// Video
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Video link', 'total-theme-core' ),
					'param_name' => 'video',
					'description' => esc_html__('Enter a URL that is compatible with WP\'s built-in oEmbed feature or a self-hosted video URL.', 'total-theme-core' ),
					'group' => esc_html__( 'Video', 'total-theme-core' ),
				),
				// Link (button)
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Link Type', 'total-theme-core' ),
					'param_name' => 'onclick_el',
					'std' => 'button',
					'choices' => array(
						'button' => esc_html__( 'Button', 'total-theme-core' ),
						'container' => esc_html__( 'Whole Container', 'total-theme-core' ),
					),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Button Text', 'total-theme-core' ),
					'param_name' => 'button_text',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'dependency' => array( 'element' => 'onclick_el', 'value' => 'button' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Button Class', 'total-theme-core' ),
					'param_name' => 'button_el_class',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'description' => vcex_shortcode_param_description( 'el_class' ),
					'dependency' => array( 'element' => 'onclick_el', 'value' => 'button' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'On click action', 'total-theme-core' ),
					'param_name' => 'onclick',
					'value' => array(
						esc_html__( 'None', 'total-theme-core' ) => '',
						esc_html__( 'Go to custom link', 'total-theme-core' ) => 'custom_link',
						esc_html__( 'Go to internal page', 'total-theme-core' ) => 'internal_link',
						esc_html__( 'Scroll to section', 'total-theme-core' ) => 'local_scroll',
						esc_html__( 'Toggle Element', 'total-theme-core' ) => 'toggle_element',
						esc_html__( 'Go to custom field value', 'total-theme-core' ) => 'custom_field',
						esc_html__( 'Go to callback function value', 'total-theme-core' ) => 'callback_function',
						esc_html__( 'Open inline content or iframe popup', 'total-theme-core' ) => 'popup',
						esc_html__( 'Open image lightbox', 'total-theme-core' ) => 'lightbox_image',
						esc_html__( 'Open image gallery lightbox', 'total-theme-core' ) => 'lightbox_gallery',
						esc_html__( 'Open video lightbox', 'total-theme-core' ) => 'lightbox_video',
						esc_html__( 'Open post image gallery lightbox', 'total-theme-core' ) => 'lightbox_post_gallery',
						esc_html__( 'Open post video lightbox', 'total-theme-core' ) => 'lightbox_post_video',
					),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Link', 'total-theme-core' ),
					'param_name' => 'onclick_url',
					'description' => vcex_shortcode_param_description( 'text' ),
					'dependency' => array(
						'element' => 'onclick',
						'value' => array(
							'custom_link',
							'local_scroll',
							'popup',
							'lightbox_image',
							'lightbox_video',
							'toggle_element'
						),
					),
					'description' => esc_html__( 'Enter your custom link url, lightbox url or local/toggle element ID (including a # at the front).', 'total-theme-core' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'vc_link',
					'heading' => esc_html__( 'Internal Link', 'total-theme-core' ),
					'param_name' => 'onclick_internal_link',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'description' => esc_html__( 'This setting is used only if you want to link to an internal page to make it easier to find and select it. Any extra settings in the popup (title, target, nofollow) are ignored.', 'total-theme-core' ),
					'dependency' => array( 'element' => 'onclick', 'value' => 'internal_link' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Custom Field ID', 'total-theme-core' ),
					'param_name' => 'onclick_custom_field',
					'dependency' => array( 'element' => 'onclick', 'value' => 'custom_field' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Callback Function', 'total-theme-core' ),
					'param_name' => 'onclick_callback_function',
					'dependency' => array( 'element' => 'onclick', 'value' => 'callback_function' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'description' => '<a href="https://wpexplorer-themes.com/total/docs/how-to-whitelist-callback-functions-for-elements/" target="_blank" rel="noopener noreferrer">' . esc_html__( 'Callback functions must be whitelisted', 'total-theme-core' ) . '</a>',
				),
				array(
					'type' => 'attach_image',
					'heading' => esc_html__( 'Lightbox Image', 'total-theme-core' ),
					'param_name' => 'onclick_lightbox_image',
					'dependency' => array( 'element' => 'onclick', 'value' => 'lightbox_image' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'attach_images',
					'heading' => esc_html__( 'Lightbox Gallery', 'total-theme-core' ),
					'param_name' => 'onclick_lightbox_gallery',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'dependency' => array( 'element' => 'onclick', 'value' => 'lightbox_gallery' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title Attribute', 'total-theme-core' ),
					'param_name' => 'onclick_title',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'dependency' => array( 'element' => 'onclick', 'not_empty' => true ),
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Target', 'total-theme-core' ),
					'param_name' => 'onclick_target',
					'std' => 'self',
					'choices' => array(
						'self'   => esc_html__( 'Self', 'total-theme-core' ),
						'_blank' => esc_html__( 'Blank', 'total-theme-core' ),
					),
					'dependency' => array(
						'element' => 'onclick',
						'value' => array( 'custom_link', 'internal_link', 'custom_field', 'callback_function' ),
					),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'vcex_select_buttons',
					'heading' => esc_html__( 'Rel Attribute', 'total-theme-core' ),
					'param_name' => 'onclick_rel',
					'std' => '',
					'choices' => array(
						'' => esc_html__( 'None', 'total-theme-core' ),
						'nofollow' => esc_html__( 'Nofollow', 'total-theme-core' ),
						'sponsored' => esc_html__( 'Sponsored', 'total-theme-core' ),
					),
					'dependency' => array(
						'element' => 'onclick',
						'value' => array( 'custom_link', 'internal_link', 'custom_field', 'callback_function' ),
					),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Video Icon', 'total-theme-core' ),
					'param_name' => 'video_icon',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'value' => array(
						esc_html__( 'None', 'total-theme-core' ) => '',
						esc_html__( 'Style 1', 'total-theme-core' ) => '1',
						esc_html__( 'Style 2', 'total-theme-core' ) => '2',
						esc_html__( 'Style 3', 'total-theme-core' ) => '3',
						esc_html__( 'Style 4', 'total-theme-core' ) => '4',
					),
					'dependency' => array( 'element' => 'onclick', 'value' => 'lightbox_video' ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Lightbox Dimensions (optional)', 'total-theme-core' ),
					'param_name' => 'onclick_lightbox_dims',
					'description' => esc_html__( 'Enter a custom width and height for your lightbox pop-up window. Use format widthxheight. Example: 1920x1080.', 'total-theme-core' ),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'dependency' => array( 'element' => 'onclick', 'value' => array( 'lightbox_video', 'popup' ) ),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Lightbox Title', 'total-theme-core' ),
					'param_name' => 'onclick_lightbox_title',
					'dependency' => array(
						'element' => 'onclick',
						'value' => array( 'lightbox_image', 'lightbox_video', 'popup' )
					),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'textarea',
					'heading' => esc_html__( 'Lightbox Caption', 'total-theme-core' ),
					'param_name' => 'onclick_lightbox_caption',
					'dependency' => array(
						'element' => 'onclick',
						'value' => array( 'lightbox_image', 'lightbox_video', 'popup' )
					),
					'group' => esc_html__( 'Link', 'total-theme-core' ),
				),
				array(
					'type' => 'exploded_textarea',
					'heading' => esc_html__( 'Custom Data Attributes', 'total-theme-core' ),
					'param_name' => 'onclick_data_attributes',
					'group' => esc_html__( 'Link', 'total-theme-core' ),
					'dependency' => array(
						'element' => 'onclick',
						'value' => array(
							'custom_link',
							'custom_field',
							'callback_function',
							'popup',
						),
					),
					'description' => esc_html__( 'Enter your custom data attributes in the format of data|value. Hit enter after each set of data attributes.', 'total-theme-core' ),
				),
				// Hidden fields
				array( 'type' => 'hidden', 'param_name' => 'tablet_widths' ),
				array( 'type' => 'vcex_select_buttons', 'param_name' => 'phone_widths' ),
			);

			return apply_filters( 'vcex_shortcode_params', $params, 'vcex_feature_box' );
		}

		/**
		 * Parses deprecated params.
		 */
		public static function parse_deprecated_attributes( $atts = '' ) {
			if ( empty( $atts ) || ! is_array( $atts ) ) {
				return $atts;
			}

			$stack_bk = '';

			if ( ! empty( $atts['tablet_widths'] ) ) {
				$stack_bk = 'custom';
				$atts['custom_stack_bk'] = '960px';
				unset( $atts['tablet_widths'] );
			} elseif ( ! empty( $atts['phone_widths'] ) ) {
				$stack_bk = 'md';
				unset( $atts['phone_widths'] );
			}

			if ( $stack_bk ) {
				$atts['stack_bk'] = $stack_bk;
			}

			return $atts;
		}

	}

}
new VCEX_Feature_Box_Shortcode;

if ( class_exists( 'WPBakeryShortCode' ) && ! class_exists( 'WPBakeryShortCode_Vcex_Feature_Box' ) ) {
	class WPBakeryShortCode_Vcex_Feature_Box extends WPBakeryShortCode {}
}