<?php
/**
 * Grid Container shortcode template.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.4.5
 */

defined( 'ABSPATH' ) || exit;

$html        = '';
$atts        = vcex_shortcode_atts( 'vcex_grid_container', $atts, 'VCEX_Grid_Container_Shortcode' );
$breakpoints = array( 'sm', 'md', 'lg', 'xl' );

$classes = array(
	'vcex-grid-container',
	'vcex-module',
	'wpex-grid',
	'wpex-gap-20',
);

if ( ! empty( $atts['width'] ) ) {
	$classes[] = 'wpex-mx-auto';
}

$classes[] = 'wpex-grid-cols-' . sanitize_html_class( absint( $atts['columns'] ) );

foreach( $breakpoints as $bk ) {
	if ( ! empty( $atts['columns_' . $bk] ) && is_numeric( $atts['columns_' . $bk] ) ) {
		$classes[] = 'wpex-' . $bk . '-grid-cols-' . sanitize_html_class( absint( $atts['columns_' . $bk] ) );
	}
}

if ( ! empty( $atts['align_items'] ) ) {
	$classes[] = vcex_parse_align_items_class( $atts['align_items'] );
}

if ( ! empty( $atts['justify_items'] ) && is_string( $atts['justify_items'] ) ) {
	$classes[] = 'wpex-justify-items-' . sanitize_html_class( $atts['justify_items'] );
}

if ( ! empty( $atts['shadow'] ) ) {
	$classes[] = vcex_parse_shadow_class( $atts['shadow'] );
}

if ( ! empty( $atts['visibility'] ) ) {
	$classes[] = vcex_parse_visibility_class( $atts['visibility'] );
}

if ( ! empty( $atts['el_class'] ) ) {
	$classes[] = vcex_get_extra_class( $atts['el_class'] );
}

if ( ! empty( $atts['css'] ) ) {
	$classes[] = vcex_vc_shortcode_custom_css_class( $atts['css'] );
}

$classes = array_filter( $classes );

$style = '';

$inline_style = vcex_inline_style( array(
	'gap'       => $atts['gap'] ?? null,
	'max_width' => $atts['width'] ?? null,
), true );

$html .= '<div class="' . esc_attr( implode( ' ', $classes ) ) . '"' . vcex_get_unique_id( $atts['unique_id'] ?? null ) . $inline_style . '>';

	$html .= do_shortcode( wp_kses_post( $content ) );

$html .= '</div>';

echo $html; // @codingStandardsIgnoreLine