/*jshint esversion: 6 */
( function( $ ) {
	'use strict';

	/**
	 * Return responsive value from a group of inputs.
	 */
	var vcexGetResponsiveSizeValue = function( $allInputs ) {
		var valArray = [];
		var firstVal = null;
		var allSame = true;
		$allInputs.each( function( index, el ) {
			var $this = $( this );
			var val = $this.val();
			if ( 0 === index ) {
				firstVal = val;
			}
			if ( firstVal !== val ) {
				allSame = false;
			}
			if ( val ) {
				var device = $this.attr( 'name' ) || $this.attr( 'data-vcex-device' );
				device = device + ':' + val;
				valArray.push( device );
			}
		} );
		if ( allSame || 1 === valArray.length ) {
			return firstVal;
		} else {
			return valArray.join('|');
		}
	};

	/**
	 * Chosen selects.
	 */
	if ( $.fn.chosen !== undefined ) {
		$( '.vcex-chosen' ).chosen( {
			search_contains: true,
			inherit_select_classes: true
		} );
		$( '.vcex-chosen-alt' ).chosen( {
			disable_search: true,
			inherit_select_classes: true
		} );
	}

	/**
	 * Alignment select.
	 */
	$( '.vc_edit_form_elements' ).on( 'click', '.vcex-alignments-param .vcex-alignment-opt', function(e) {
		var $this = $( this );
		var $parent = $this.parent( '.vcex-alignments-param' );
		var $hiddenInput = $parent.find( '.vcex-hidden-input' );
		$parent.find( '.vcex-alignment-opt' ).removeClass( 'vcex-active' );
		$this.addClass( 'vcex-active' );
		$hiddenInput.val( $this.data( 'value' ) ).trigger( 'change' );
	} );

	/**
	 * Prevent incorrect input for number param.
	 */
	$( '.vcex-number-param' ).change( function() {
		var val = $( this ).val();
		var min = parseInt( $( this ).attr( 'min' ) );
		var max = parseInt( $( this ).attr( 'max' ) );
		if ( min && max && val ) {
			if ( val > max ) {
				$( this ).val( max );
			} else if ( val < min ) {
				$( this ).val( min );
			}
		}
	} );

	/**
	 * Sorter.
	 */
	if ( $.fn.sortable !== undefined ) {
		var sorterParam = $( '.vcex-sorter-param' );

		sorterParam.each( function() {
			var $this = $( this );

			// Create sortable.
			$this.sortable();
			$this.disableSelection();

			// Update values on sortstop.
			$this.on( 'sortstop', function( event, ui ) {
				vcexUpdateSortable( $this );
			} );

			// Toggle classes.
			$this.find( 'li > a' ).click( function() {
				$( this ).find( '.ticon' ).toggleClass( 'ticon-rotate-180' );
				$( this ).parents( 'li:eq(0)' ).toggleClass( 'vcex-disabled' );
				vcexUpdateSortable( $this );
			} );

		} );
	}

	// Update sorter hidden field.
	function vcexUpdateSortable( el ) {
		var values = [];
		el.find( 'li' ).each( function() {
			if ( ! $( this ).hasClass( 'vcex-disabled' ) ) {
				values.push( $( this ).attr( 'data-value' ) );
			}
		} );
		$( el ).next( 'input.wpb_vc_param_value' ).val( values ).trigger( 'change' );
	}

	/**
	 * Custom button options.
	 */
	$( '.vc_edit_form_elements' ).on( 'click', '.vcex-custom-select .vcex-opt', function(e) {
		var $this = $( this );
		var $parent = $this.parent( '.vcex-custom-select' );
		var $hiddenInput = $parent.find( '.vcex-hidden-input' );
		$parent.find( '.vcex-opt' ).removeClass( 'vcex-active' );
		$this.addClass( 'vcex-active' );
		$hiddenInput.val( $this.data( 'value' ) ).trigger( 'change' );
	} );

	/**
	 * On/Off switch.
	 */
	$( '.vc_edit_form_elements' ).on( 'click', '.vcex-ofswitch .vcex-btn', function(e) {
		var $this = $( this );
		var $parent = $this.parent( '.vcex-ofswitch' );
		var $hiddenInput = $parent.find( '.vcex-hidden-input' );
		$parent.find( '.vcex-btn' ).removeClass( 'vcex-active' );
		$this.addClass( 'vcex-active' );
		$hiddenInput.val( $this.data( 'value' ) ).trigger( 'change' );
	} );

	/**
	 * Responsive column.
	 */
	$( '.vcex-responsive-column-select' ).on( 'change', function( e ) {
		var valArray = [];
		var $parent = $( this ).closest( '.vcex-responsive-columns-param' );
		var $allSettings = $parent.find( 'select' );
		var $hiddenInput = $parent.find( 'input.wpb_vc_param_value' );
		$allSettings.each( function( index, el ) {
			var $this = $( this );
			var val = $this.val();
			if ( val ) {
				var parsed = $this.attr( 'name' ) + ':' + val;
				valArray.push( parsed );
			}
		} );
		$hiddenInput.val( valArray.join('|') ).trigger();
	} );

	/**
	 * Responsive field.
	 */
	vc.atts.vcex_responsive_sizes = {
		init: function( param, $field ) {
			var $inputs = $field.find( '.vcex-param-responsive-fields__item input' );
			var $wpbInput = $field.find( '.wpb_vc_param_value' );
			$inputs.on( 'change', function( event ) {
				$wpbInput.val( vcexGetResponsiveSizeValue( $inputs ) ).trigger( 'change' );
			} );
		}
	};

	/**
	 * Font Size field.
	 */
	vc.atts.vcex_font_size = {
		init: function( param, $field ) {
			var $el         = $field.find( '.vcex-param-font-size' );
			var $inputs     = $field.find( '.vcex-param-font-size__item input' );
			var $wpbInput   = $field.find( '.wpb_vc_param_value' );
			var $toggle     = $field.find( '.vcex-param-font-size__toggle' );
			var $quickLinks = $field.find( '.vc_description a' );
			var lastFocused;

			$inputs.on( 'change', function( event ) {
				if ( 'true' === $toggle.attr( 'aria-pressed' ) ) {
					$wpbInput.val( vcexGetResponsiveSizeValue( $inputs ) ).trigger( 'change' );
				} else {
					$wpbInput.val( $inputs.first().val() ).trigger( 'change' );
				}
			} );

			$inputs.on( 'focus', function() {
				lastFocused = $(this);
			} );

			$toggle.click( function() {
				if ( 'true' === $toggle.attr( 'aria-pressed' ) ) {
					$toggle.attr( 'aria-pressed', 'false' );
					$el.addClass( 'vcex-param-font-size--single' );
					$wpbInput.val( $inputs.first().val() ).trigger( 'change' );
				} else {
					$toggle.attr( 'aria-pressed', 'true' );
					$el.removeClass( 'vcex-param-font-size--single' );
					$wpbInput.val( vcexGetResponsiveSizeValue( $inputs ) ).trigger( 'change' );
				}
				return false;
			} );

			// QuickLinks
			if ( $quickLinks ) {
				document.addEventListener( 'click', function( event ) {
					let input = event.target.closest( '.vcex-param-font-size__item input' );
					if ( ! input ) {
						lastFocused = null;
					}
				} );
				$quickLinks.click( function() {
					let targetInput = lastFocused || $inputs.first();
					targetInput.val( $(this).text() );
					$wpbInput.val( vcexGetResponsiveSizeValue( $inputs ) ).trigger( 'change' );
					return false;
				} );
			}

		}
	};

	/**
	 * Top Right Bottom Left.
	 */
	 vc.atts.vcex_trbl = {
		init: function( param, $field ) {
			var $inputs = $field.find( '.vcex-param-trbl__item input' );
			var $wpbInput = $field.find( '.wpb_vc_param_value' );
			$inputs.on( 'change', function( event ) {
				var firstValue = null;
				var allSame = true;
				var valArray = [];

				$inputs.each( function( index, el ) {
					var $this = $( this );
					var val = $this.val();

					if ( 0 === index ) {
						firstValue = val;
					}

					if ( firstValue !== val ) {
						allSame = false;
					}

					if ( val ) {
						var parsed = $this.attr( 'data-vcex-position' ) + ':' + val;
						valArray.push( parsed );
					}

				} );

				if ( allSame ) {
					$wpbInput.val( firstValue ).trigger( 'change' );
				} else {
					$wpbInput.val( valArray.join('|') ).trigger( 'change' );
				}

			} );
		}
	 };

	/**
	 * Text with choices param.
	 */
	vc.atts.vcex_preset_textfield = {
		init: function( param, $field ) {

			// Fields.
			var $presetEl = $field.find( '.vcex-param-preset-textfield__preset' );
			var $customEl = $field.find( '.vcex-param-preset-textfield__custom' );

			// Inputs.
			var $presetSelect = $presetEl.find( '.vcex-param-preset-textfield__select' );
			var $customInput = $customEl.find( '.vcex-param-preset-textfield__input' );
			var $wpbInput = $field.find( '.wpb_vc_param_value' );

			// Toggle
			var $toggle = $field.find( '.vcex-param-preset-textfield__toggle' );
			var $toggleState = $toggle.attr( 'aria-pressed' );
			var $vc_desc = $field.find( '.vc_description' );

			if ( 'true' !== $toggleState ) {
				$vc_desc.hide(); // hide description if not needed.
			}

			// Show and hide fields when using the button toggle.
			$toggle.click( function() {
				if ( 'true' === $toggle.attr( 'aria-pressed' ) ) {
					$toggle.attr( 'aria-pressed', 'false' );
					$presetEl.show();
					$presetSelect.focus().trigger( 'change' );
					$customEl.hide();
					$vc_desc.hide();
				} else {
					$toggle.attr( 'aria-pressed', 'true' );
					$presetEl.hide();
					$customEl.show();
					$customEl.find( 'input' ).first().focus().trigger( 'change' );
					$vc_desc.show();
				}
				return false;
			} );

			// Update hidden input for responsive fields.
			(function() {
				var $responsiveFields = $field.find( '.vcex-param-responsive-fields__item input' );

				if ( ! $responsiveFields.length ) {
					return;
				}

				$responsiveFields.on( 'change', function() {
					$customInput.val( vcexGetResponsiveSizeValue( $responsiveFields ) ).trigger( 'change' );
				} );

			})();

			var updateWpbField = function( event ) {
				$wpbInput.val( $( event.target ).val() ).trigger( 'change' );
			};

			// Update wpbakery hidden field when seleting new preset or changing custom input.
			$presetSelect.on( 'change', updateWpbField );
			$customInput.on( 'change', updateWpbField );

		}
	};

	/**
	 * Min Max.
	 */
	vc.atts.vcex_min_max = {
		init: function( param, $field ) {
			var $fields = $field.find( '.vcex-param-min-max__item input' );
			var $hiddenInput = $field.find( 'input.wpb_vc_param_value' );
			$fields.on( 'input', function() {
				var inputVals = [];
				$fields.each( function( index, el ) {
					var $this = $( this );
					var val = $this.val();
					if ( val ) {
						inputVals.push( parseInt( val ) + 'px' );
					}
				} );
				if ( 1 === inputVals.length ) {
					$hiddenInput.val( '' );
				} else {
					$hiddenInput.val( inputVals.join('|') );
				}
			} );
		}
	};

	/**
	 * Colorpicker with palette.
	 */
	vc.atts.vcex_colorpicker = {
		parse: function( param ) {
			const $field       = this.content().find( '.wpb_vc_param_value[name=' + param.param_name + ']' );
			const $block       = $field.parent();
			const $selectField = $block.find( '.vcex-color-param__select' );
			const $color_field = $block.find( '.vcex-color-param__picker' );
			if ( $selectField.val() ) {
				return $selectField.val();
			}
			if ( $color_field.val() ) {
				return $color_field.val();
			}
			return '';
		},
		init: function( param, $field ) {
			vc.atts.colorpicker.init.call( this, param, $field ); // must go first.
			const $el          = $field.find( '.vcex-color-param' );
			const $selectField = $field.find( '.vcex-color-param__select' );
			const $preview     = $field.find( '.vcex-color-param__preview' );
			//var $hiddenField = $field.find( 'input.wpb_vc_param_value' );
			// On select change.
			$selectField.change( function() {
				if ( $(this).val() ) {
					const selectedColor = $(this).find( ':selected' ).data( 'color' );
					if ( 'term_color' === selectedColor ) {
						$preview.css( 'background', 'transparent' );
						$el.addClass( 'vcex-color-param--hide-preview' );
					} else {
						$preview.css( 'background-color', selectedColor);
						$el.removeClass( 'vcex-color-param--hide-preview' );
					}
					$el.removeClass( 'vcex-color-param--custom' );
					//$hiddenField.val( selectedColor ).trigger();
				} else {
					$el.addClass( 'vcex-color-param--custom' );
					$el.removeClass( 'vcex-color-param--hide-preview' );
					$preview.css( 'background-color', '' );
					//$hiddenField.val( '' ).trigger();
				}
			} );
		}
	};

} ( jQuery ) );