<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_page_header'] = array(
	'title' => esc_html__( 'Page Header Title', 'total' ),
	'panel' => 'wpex_general',
	'settings' => array(
		array(
			'id' => 'page_header_style',
			//'transport' => 'postMessage', // needs refresh because of body class and active_callbacks
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => 'page_header_style',
			),
		),
		array(
			'id' => 'page_header_breakpoint',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Responsive Breakpoint', 'total' ),
				'type' => 'select',
				'choices' => 'breakpoint',
				'description' => esc_html__( 'Option used for header styles that have content on the side such as breadcrumbs.', 'total' ),
			),
		),
		array(
			'id' => 'page_header_min_height',
			'transport' => 'postMessage',
			'control_display' => array(
				'check' => 'page_header_style',
				'value' => 'background-image',
			),
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Min-Height', 'total' ),
				'placeholder' => '400',
			),
			'inline_css' => array(
				'target' => '.page-header.background-image-page-header',
				'alter' => 'min-height',
			),
		),
		array(
			'id' => 'page_header_align_items',
			'transport' => 'postMessage',
			'default' => 'center',
			'control_display' => array(
				'check' => 'page_header_style',
				'value' => 'background-image',
			),
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Vertical Alignment', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'start' => esc_html__( 'Top', 'total' ),
					'center' => esc_html__( 'Center', 'total' ),
					'end' => esc_html__( 'Bottom', 'total' ),
				),
			),
		),
		array(
			'id' => 'page_header_text_align',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Text Align', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'left' => esc_html__( 'Left', 'total' ),
					'center' => esc_html__( 'Center', 'total' ),
					'right' => esc_html__( 'Right', 'total' ),
				),
			),
		),
		array(
			'id' => 'page_header_overlay_opacity',
			'transport' => 'postMessage',
			'control_display' => array(
				'check' => 'page_header_style',
				'value' => 'background-image',
			),
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Overlay Opacity', 'total' ),
				'choices' => 'opacity',
			),
		),
		array(
			'id' => 'page_header_overlay_bg',
			'transport' => 'postMessage',
			'control_display' => array(
				'check' => 'page_header_style',
				'value' => 'background-image',
			),
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Overlay Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '.background-image-page-header-overlay',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'page_header_hidden_main_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Hidden Page Header Title Spacing', 'total' ),
				'description' => esc_html__( 'When the page header title is set to hidden there won\'t be any space between the header and the main content. You can enter a default spacing here.', 'total' ),
			),
			'inline_css' => array(
				'target' => '.page-header-disabled:not(.has-overlay-header):not(.no-header-margin) #content-wrap',
				'alter' => 'padding-top',
			),
		),
		array(
			'id' => 'page_header_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Top Padding', 'total' ),
				'placeholder' => '20',
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'padding-top',
			),
		),
		array(
			'id' => 'page_header_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Bottom Padding', 'total' ),
				'placeholder' => '20',
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'padding-bottom',
			),
		),
		array(
			'id' => 'page_header_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Bottom Margin', 'total' ),
				'placeholder' => '20px',
			),
			'inline_css' => array(
				'target' => '.page-header',
				'alter' => 'margin-bottom',
			),
		),
		array(
			'id' => 'page_header_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'page_header_title_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods .page-header-title',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'page_header_top_border',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Top Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'border-top-color',
			),
		),
		array(
			'id' => 'page_header_bottom_border',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Bottom Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'border-bottom-color',
			),
		),
		array(
			'id' => 'page_header_top_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Top Border Width', 'total' ),
				'placeholder' => '1',
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'border-top-width',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'page_header_bottom_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Bottom Border Width', 'total' ),
				'placeholder' => '1',
			),
			'inline_css' => array(
				'target' => '.page-header.wpex-supports-mods',
				'alter' => 'border-bottom-width',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'page_header_background_img',
			'transport' => 'refresh',
			'control' => array(
				'type' => 'media',
				'mime_type' => 'image',
				'label' => esc_html__( 'Background Image', 'total' ),
			),
		),
		array(
			'id' => 'page_header_background_img_style',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'total' ),
				'type' => 'select',
				'choices' => 'bg_style',
			),
			'control_display' => array(
				'check' => 'page_header_background_img',
				'value' => 'not_empty',
			),
		),
		array(
			'id' => 'page_header_background_fetch_thumbnail',
			'control' => array(
				'type' => 'wpex_multi_select',
				'label' => esc_html__( 'Fetch Background From Featured Image', 'total' ),
				'description' => esc_html__( 'Check the box next to any post type where you want to display the featured image as the page header title background.', 'total' ),
				'choices' => 'post_types',
			),
			'control_display' => array(
				'check' => 'page_header_background_img',
				'value' => 'not_empty',
			),
		),
		array(
			'id' => 'page_header_subheading_location',
			'transport' => 'refresh',
			'default' => 'page_header_content',
			'control' => array(
				'label' => esc_html__( 'Subheading Location', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'page_header_content' => esc_html__( 'Page Header Content', 'total' ),
					'page_header_aside' => esc_html__( 'Page Header Aside', 'total' ),
				),
			),
		),
	),
);