<?php
defined( 'ABSPATH' ) || exit;

// General
$this->sections['wpex_togglebar'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'settings' => array(
		array(
			'id' => 'toggle_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Toggle Bar', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'toggle_bar_fullwidth',
			'control' => array(
				'label' => esc_html__( 'Full Width', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'toggle_bar_remember_state',
			'control' => array(
				'label' => esc_html__( 'Remember state', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'If enabled the theme will store a cookie whenever the state changes so the next time the user visits the site in the same browser it will display in that state.', 'total' ),
			),
		),
		array(
			'id' => 'toggle_bar_page',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Template', 'total' ),
				'type' => 'wpex-dropdown-pages',
				'include_templates' => true,
				'description' => esc_html__( 'Leave empty to display Custom Content field.', 'total' ),
			),
		),
		array(
			'id' => 'toggle_bar_content',
			'control' => array(
				'label' => esc_html__( 'Custom Content', 'total' ),
				'type' => 'textarea',
				'description' => esc_html__( 'HTML and shortcodes allowed.', 'total' ),
			),
			'control_display' => array(
				'check' => 'toggle_bar_page',
				'value' => 'false', // same as empty.
			),
		),
		array(
			'id' => 'toggle_bar_visibility',
			'control' => array(
				'label' => esc_html__( 'Visibility', 'total' ),
				'type' => 'wpex-visibility-select',
			),
		),
		array(
			'id' => 'toggle_bar_default_state',
			'default' => 'hidden',
			'control' => array(
				'label' => esc_html__( 'Default State', 'total' ),
				'type' => 'select',
				'choices' => array(
					'hidden' => esc_html__( 'Closed', 'total' ),
					'visible' => esc_html__( 'Open', 'total' ),
				),
			),
		),
		array(
			'id' => 'toggle_bar_enable_dismiss',
			'control' => array(
				'label' => esc_html__( 'Close Button', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to display a close button (x) instead of allowing users to open and close the Toggle Bar.', 'total' ),
			),
			'control_display' => array(
				'check' => 'toggle_bar_default_state',
				'value' => 'visible',
			),
		),
		array(
			'id' => 'toggle_bar_display',
			'default' => 'overlay',
			'control' => array(
				'label' => esc_html__( 'Display', 'total' ),
				'type' => 'select',
				'choices' => array(
					'overlay' => esc_html__( 'Overlay (opens over site content)', 'total' ),
					'inline' => esc_html__( 'Inline (opens above site content)', 'total' ),
				),
			),
		),
		array(
			'id' => 'toggle_bar_animation',
			'default' => 'fade',
			'control' => array(
				'label' => esc_html__( 'Open/Close Animation', 'total' ),
				'type' => 'select',
				'choices' => array(
					'fade' => esc_html__( 'Fade', 'total' ),
					'fade-slide' => esc_html__( 'Fade & Slide Down', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'toggle_bar_display',
				'value' => 'overlay',
			),
		),
		// Button
		array(
			'id' => 'toggle_bar_button_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Toggle Button', 'total' ),
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
		),
		array(
			'id' => 'toggle_bar_button_icon',
			'default' => 'plus',
			'control' => array(
				'label' => esc_html__( 'Button Icon', 'total' ),
				'type' => 'wpex-fa-icon-select',
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
		),
		array(
			'id' => 'toggle_bar_button_icon_active',
			'default' => 'minus',
			'control' => array(
				'label' => esc_html__( 'Button Icon: Active', 'total' ),
				'type' => 'wpex-fa-icon-select',
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
		),
		array(
			'id' => 'toggle_bar_btn_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Button Background', 'total' ),
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
			'inline_css' => array(
				'target' => '.toggle-bar-btn',
				'alter' => array( 'border-top-color', 'border-right-color' ),
			),
		),
		array(
			'id' => 'toggle_bar_btn_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Button Color', 'total' ),
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
			'inline_css' => array(
				'target' => '.toggle-bar-btn span',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'toggle_bar_btn_hover_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Button Hover Background', 'total' ),
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
			'inline_css' => array(
				'target' => '.toggle-bar-btn:hover',
				'alter' => array( 'border-top-color', 'border-right-color' ),
			),
		),
		array(
			'id' => 'toggle_bar_btn_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Button Hover Color', 'total' ),
				'active_callback' => 'wpex_cac_toggle_bar_has_toggle_btn',
			),
			'inline_css' => array(
				'target' => '.toggle-bar-btn:hover span',
				'alter' => 'color',
			),
		),
		// Design
		array(
			'id' => 'toggle_bar_design_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Design', 'total' ),
			),
		),
		array(
			'id' => 'toggle_bar_padding_y',
			'control' => array(
				'label' => esc_html__( 'Vertical Padding', 'total' ),
				'type'  => 'select',
				'choices' => 'margin',
			),
		),
		array(
			'id' => 'toggle_bar_min_height',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Minimum Height', 'total' ),
				'type'  => 'wpex_length_unit',
			),
			'inline_css' => array(
				'target' => '#toggle-bar',
				'alter' => 'min-height',
			),
		),
		array(
			'id' => 'toggle_bar_align',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Alignment', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'start' => esc_html__( 'Left', 'total' ),
					'center' => esc_html__( 'Center', 'total' ),
					'end' => esc_html__( 'Right', 'total' ),
				),
			),
		),
		array(
			'id' => 'toggle_bar_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '#toggle-bar-wrap',
				'alter' => array(
					'--wpex-surface-1',
					'background', // @todo maybe remove this in the future.
				),
			),
		),
		array(
			'id' => 'toggle_bar_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#toggle-bar-wrap',
				'alter' => array(
					'color',
					'--wpex-text-2', // incase it's used somewhere inside.
				),
			),
		),
		array(
			'id' => 'toggle_bar_heading_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Headings Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#toggle-bar-wrap',
				'alter' => array(
					'--wpex-text-1',
					'--wpex-heading-color',
					'--wpex-heading-link-color',
				),
			),
		),
		array(
			'id' => 'toggle_bar_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#toggle-bar-wrap',
				'alter' => array(
					'--wpex-link-color',
					'--wpex-hover-link-color',
					'--wpex-hover-heading-link-color',
				),
			),
		),
		array(
			'id' => 'toggle_bar_border',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border', 'total' ),
				'description' => esc_html__( 'Used for the "Inline" display style bottom border.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#toggle-bar-wrap',
				'alter' => 'border-color',
				'important' => true, // @Todo is this needed?
			),
		),
	)
);