<?php
namespace TotalTheme\Filters;

defined( 'ABSPATH' ) || exit;

/**
 * Hooks into "pre_get_posts".
 *
 * @package TotalTheme
 * @subpackage Filters
 * @version 5.4
 */
final class Pre_Get_posts {

	/**
	 * Callback method.
	 */
	public static function callback( $query ) {
		if ( is_admin() || ! $query->is_main_query() ) {
			return $query;
		}

		// Search functions.
		if ( $query->is_search() ) {
			return self::alter_search( $query );
		}

		// Exclude categories from the main blog.
		if ( $query->is_home()
			|| is_page_template( 'templates/blog.php' )
			|| is_page_template( 'templates/blog-content-above.php' )
		) {
			if ( $cats = wpex_blog_exclude_categories() ) {
				$query->set( 'category__not_in', $cats );
			}
			return $query;
		}

		// Category pagination.
		if ( $query->is_category() ) {
			$current_term = $query->get_queried_object_id();
			$term_ppp = wpex_get_category_meta( $current_term, 'wpex_term_posts_per_page' );
			if ( $term_ppp ) {
				$query->set( 'posts_per_page', $term_ppp );
				return $query;
			}
		}

		// Post types unlimited checks (should be last).
		if ( WPEX_PTU_ACTIVE ) {
			if ( $query->is_post_type_archive() ) {
				$ptu_check = intval( wpex_get_ptu_type_mod( $query->get_queried_object()->name, 'archive_posts_per_page' ) );
				if ( ! empty( $ptu_check ) ) {
					$query->set( 'posts_per_page', $ptu_check );
				}
			}
			if ( $query->is_tax() && ! empty( $query->get_queried_object() ) ) {
				$ptu_check = intval( wpex_get_ptu_tax_mod( $query->get_queried_object()->taxonomy, 'posts_per_page' ) );
				if ( ! empty( $ptu_check ) ) {
					$query->set( 'posts_per_page', $ptu_check );
				}
			}
		}
	}

	/**
	 * Alters the search query.
	 */
	protected static function alter_search( $query ) {
		$post_type = $_GET['post_type'] ?? null;

		// Prevent issues with Woo Search.
		if ( WPEX_WOOCOMMERCE_ACTIVE && 'product' === $post_type ) {
			return $query;
		}

		// Search posts per page.
		$query->set( 'posts_per_page', get_theme_mod( 'search_posts_per_page', '10' ) );

		// Alter search post types unless the post_type arg is in the URL.
		if ( ! $post_type ) {

			// Display standard posts only.
			if ( get_theme_mod( 'search_standard_posts_only', false ) ) {
				$query->set( 'post_type', 'post' );
				return $query;
			}

			// Exclude post types from search results.
			$searchable_types = get_post_types( array(
				'public'              => true,
				'exclude_from_search' => false
			) );

			if ( is_array( $searchable_types ) ) {
				foreach ( $searchable_types as $type ) {
					if ( in_array( $type, array( 'staff', 'portfolio', 'testimonials' ) ) && ! get_theme_mod( $type . '_search', true ) ) {
						unset( $searchable_types[$type] );
					}
				}
				$searchable_type[] = 'user'; // fix for relevanssi plugin
				$query->set( 'post_type', $searchable_types );
			}

		}
		return $query;
	}

}