<?php
use TotalTheme\Header\Core as Header;
use TotalTheme\Header\Logo as Header_Logo;
use TotalTheme\Header\Overlay as Overlay_Header;

defined( 'ABSPATH' ) || exit;

/*-------------------------------------------------------------------------------*/
/* [ Table of contents ]
/*-------------------------------------------------------------------------------*/

	# Sticky Header
	# Header Flex Aside

/*-------------------------------------------------------------------------------*/
/* [ Sticky Header ]
/*-------------------------------------------------------------------------------*/

/**
 * Check if sticky header is enabled.
 *
 * @since 4.0
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_has_sticky_header() {
	if ( wpex_vc_is_inline() ) {
		return;
	}

	$check = false;

	// Get current post id.
	$post_id = wpex_get_current_post_id();

	// Check meta first it should override any filter!
	if ( $post_id && 'disable' === get_post_meta( $post_id, 'wpex_sticky_header', true ) ) {
		return false;
	}

	// Get header style.
	$header_style = Header::style();

	// Sticky header for builder.
	if ( 'builder' === $header_style ) {
		$check = get_theme_mod( 'header_builder_sticky', false );
	}

	// Standard sticky header.
	else {

		// Return false if sticky header style is set to disabled.
		if ( 'disabled' === wpex_sticky_header_style() ) {
			$check = false;
		}

		// Otherwise check if the current header style supports sticky.
		elseif ( in_array( $header_style, wpex_get_header_styles_with_sticky_support() ) ) {
			$check = true;
		}

	}

	/**
	 * Filters whether the sticky header is enabled.
	 *
	 * @param bool $check
	 */
	$check = (bool) apply_filters( 'wpex_has_fixed_header', $check );

	return $check; // @todo rename to wpex_has_sticky_header
}

/**
 * Get sticky header style.
 *
 * @since 4.0
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_sticky_header_style() {
	if ( 'builder' === Header::style() ) {
		return 'standard'; // Header builder only supports standard.
	}

	// Get default style from customizer.
	$style = get_theme_mod( 'fixed_header_style', 'standard' );

	// If disabled in Customizer but enabled in meta set to "standard" style.
	if ( 'disabled' === $style && 'enable' === get_post_meta( wpex_get_current_post_id(), 'wpex_sticky_header', true ) ) {
		$style = 'standard';
	}

	// Fallback style.
	if ( ! $style ) {
		$style = 'standard';
	}

	/**
	 * Filters the header style.
	 *
	 * @param string $style
	 */
	$style = apply_filters( 'wpex_sticky_header_style', $style );

	return $style;
}

/**
 * Returns sticky header logo img retina version.
 *
 * @since 5.1
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_sticky_header_logo_img_src() {
	$logo = get_theme_mod( 'fixed_header_logo' );

	// Set sticky logo to header logo for overlay header when custom overlay logo is set
	// This way you can have a white logo on overlay but the default on sticky.
	if ( empty( $logo )
		&& ! Overlay_Header::is_global() // make sure the page is not using a global overlay header.
		&& Overlay_Header::logo_img() // check for custom overlay header logo.
		&& Overlay_Header::is_enabled() // check if overlay header is enabled.
	) {
		$header_logo = Header_Logo::get_image_id( false );
		if ( $header_logo ) {
			$logo = $header_logo;
		}
	}

	/**
	 * Filters the sticky header logo image.
	 *
	 * @param string $logo
	 */
	$logo = apply_filters( 'wpex_fixed_header_logo', $logo );

	if ( is_numeric( $logo ) ) {
		return wp_get_attachment_image_src( $logo, 'full', false );
	}

	if ( is_string( $logo ) ) {
		return array( $logo, '', '', '' );
	}
}

/**
 * Returns sticky header logo img.
 *
 * @since 4.0
 * @todo add as data attribute to prevent the need for added checks for builder header.
 * @todo move to TotalTheme\Header\Logo
 */
function wpex_sticky_header_logo_img() {
	if ( 'builder' === Header::style() ) {
		return ''; // Not needed for the sticky header builder.
	}

	$logo_src = wpex_sticky_header_logo_img_src();

	if ( isset( $logo_src[0] ) ) {
		return wpex_get_image_url( $logo_src[0]  );
	}
}

/**
 * Returns sticky header logo height.
 *
 * @since 5.3.1
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_sticky_header_logo_img_height() {
	$logo_src = wpex_sticky_header_logo_img_src();
	if ( ! empty( $logo_src[2] ) ) {
		return absint( $logo_src[2] );
	} else {
		return Header_Logo::get_image_height();
	}
}

/**
 * Returns sticky header logo width.
 *
 * @since 5.3.1
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_sticky_header_logo_img_width() {
	$logo_src = wpex_sticky_header_logo_img_src();
	if ( ! empty( $logo_src[1] ) ) {
		return absint( $logo_src[1] );
	} else {
		return Header_Logo::get_image_width();
	}
}

/**
 * Returns sticky header logo img retina version.
 *
 * @since 4.0
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_sticky_header_logo_img_retina() {
	$logo = wpex_get_translated_theme_mod( 'fixed_header_logo_retina' );

	/*
	 * Set retina logo for sticky header when the header overlay is set
	 * and the sticky header logo isn't set, since the default logo is displayed for the sticky header
	 * when using the overlay header and a custom logo.
	 */
	if ( ! $logo && ! get_theme_mod( 'fixed_header_logo' ) ) {

		$logo = wpex_get_translated_theme_mod( 'retina_logo' );

		/**
		 * Filters the header logo image retina url.
		 *
		 * @param string $logo
		 */
		$logo = apply_filters( 'wpex_header_logo_img_retina_url', $logo );

	}

	/**
	 * Filters the sticky header logo retina image.
	 *
	 * @param string $logo
	 */
	$logo = apply_filters( 'wpex_fixed_header_logo_retina', $logo );

	return wpex_get_image_url( $logo );
}

/**
 * Check if shrink sticky header is enabled.
 *
 * @since 4.0
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_has_shrink_sticky_header() {
	$check = false;

	if ( wpex_has_sticky_header()
		&& in_array( Header::style(), wpex_get_header_styles_with_sticky_support() )
		&& in_array( wpex_sticky_header_style(), array( 'shrink', 'shrink_animated' ) ) ) {
		$check = true;
	}

	/**
	 * Filters if the sticky header is set to "strink".
	 *
	 * @param bool $check
	 */
	$check = (bool) apply_filters( 'wpex_has_shrink_sticky_header', $check );

	return $check;
}

/**
 * Check if shrink sticky header is enabled.
 *
 * @since 5.1.3
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_has_shrink_sticky_header_mobile() {
	$check         = false;
	$mobile_toggle = wpex_header_menu_mobile_toggle_style();

	if ( 'icon_buttons' === $mobile_toggle || 'fixed_top' === $mobile_toggle ) {
		$check = true;
	}

	/**
	 * Filters if the sticky header is set to "strink" on mobile
	 *
	 * @param bool $check
	 */
	$check = (bool) apply_filters( 'wpex_has_shrink_sticky_header_mobile', $check );

	return $check;
}

/**
 * Return starting position for the sticky header.
 *
 * @since 4.6.5
 * @todo move to TotalTheme\Header\Sticky
 */
function wpex_sticky_header_start_position() {
	$position = get_theme_mod( 'fixed_header_start_position' );

	if ( is_singular() ) {
		$meta_position = get_post_meta( get_the_ID(), 'fixed_header_start_position', true );
		if ( $meta_position ) {
			$position = $meta_position;
		}
	}

	/**
	 * Filters if the sticky header start position.
	 *
	 * @param string $position
	 */
	$position = apply_filters( 'wpex_sticky_header_start_position', $position );

	return $position;
}

/*-------------------------------------------------------------------------------*/
/* [ Header Flex Aside ]
/*-------------------------------------------------------------------------------*/

/**
 * Header Flex Aside Class.
 *
 * @since 5.4
 * @todo move to TotalTheme\Header\Aside
 */
function wpex_header_flex_aside_class() {
	$header_style = Header::style();

	$class = array(
		'wpex-flex',
		'wpex-items-center',
		'wpex-justify-end',
		'wpex-h-100',
	);

	if ( $header_style ) {
		$class[] = 'header-' . sanitize_html_class( $header_style ) . '-aside';
	}

	$visibility = get_theme_mod( 'header_flex_aside_visibility' );

	if ( ! empty( $visibility ) ) {
		$class[] = wpex_visibility_class( $visibility );
	}

	/**
	 * Filters the header aside element class.
	 *
	 * @param array $class
	 */
	$class = (array) apply_filters( 'wpex_header_flex_aside_class', $class );

	if ( $class ) {
		echo 'class="' . esc_attr( implode( ' ', $class ) ) . '"';
	}
}

/**
 * Get Header Flex Aside content.
 *
 * @since 4.0
 * @todo move to TotalTheme\Header\Aside
 */
function wpex_header_flex_aside_content() {
	$content = wpex_get_translated_theme_mod( 'header_flex_aside_content' );

	/**
	 * Filters if the header flex aside content.
	 *
	 * @param string $content
	 */
	$content = apply_filters( 'wpex_header_flex_aside_content', $content );

	return $content;
}