<?php
defined( 'ABSPATH' ) || exit;

/**
 * Display theme svg.
 *
 * @since 5.4.5
 *
 * @param string $svg The SVG we are going to display.
 * @param int $size The size to be used for the svg width and height.
 * @return html
 */
function wpex_svg( $file = '', $size = 20 ) {
	echo wpex_get_svg( $file, $size );
}

/**
 * Get theme svgs.
 *
 * @since 5.1.2
 *
 * @param string $svg The SVG we are going to display.
 * @param int $size The size to be used for the svg width and height.
 * @return html
 */
function wpex_get_svg( $file = '', $size = 20 ) {
	if ( ! $file ) {
		return;
	}

	$svg = '';

	// Fallbacks prior to the 5.4.5 update.
	switch ( $file ) {
		case 'close':
			$file = 'material/close';
			break;
		case 'wp-spinner':
		case 'spinner':
			$file = 'loaders/wordpress';
			break;
		case 'total':
		case 'total-logo':
			$file = 'logos/total';
			break;
		case 'wpbakery-logo':
		case 'wpbakery':
			$file = 'logos/wpbakery';
			break;
		default:
			break;
	}

	if ( ! $svg ) {
		$shape_template = locate_template( 'assets/svgs/' . $file . '.svg', false );
		if ( $shape_template ) {
			$svg = file_get_contents( $shape_template );
		}
	}

	if ( $svg ) {
		$size_escaped = absint( $size );
		if ( $size_escaped ) {
			$svg = str_replace( '<svg', '<svg height="' . $size_escaped . '" width="' . $size_escaped . '"', $svg );
		}
	}

	/**
	 * Filters svg icon output
	 *
	 * @param string $svg
	 */
	$svg = (string) apply_filters( 'wpex_svg', $svg, $svg, $size );

	return $svg;
}