<?php
namespace TotalTheme\Integration;

defined( 'ABSPATH' ) || exit;

/**
 * Revslider Integration.
 *
 * @package TotalTheme
 * @subpackage Integration
 * @version 5.4.5
 */
final class Revslider {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Revslider.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function __construct() {

		// Remove meta generator tag on the frontend.
		add_filter( 'revslider_meta_generator', '__return_false' );

		// Admin tweaks.
		if ( wpex_is_request( 'admin' ) ) {
			self::admin_actions();
		}
	}

	/**
	 * Check if license is valid.
	 */
	private static function is_license_valid() {
		return get_option( 'revslider-valid', 'false' );
	}

	/**
	 * Admin actions.
	 */
	public static function admin_actions() {

		// Remove things when license isn't valid.
		if ( 'false' === self::is_license_valid() ) {
			add_action( 'admin_notices', __CLASS__ . '::remove_plugins_page_notices', PHP_INT_MAX );
		}

		// Remove metabox from various post types.
		add_action( 'do_meta_boxes', __CLASS__ . '::remove_metabox' );

		// Load CSS in the admin.
		add_action( 'admin_enqueue_scripts', __CLASS__ . '::enqueue_admin_styles' );

	}

	/**
	 * Remove Revolution Slider plugin notices.
	 */
	public static function remove_plugins_page_notices() {
		$plugin_id = 'revslider/revslider.php';

		remove_action(
			'after_plugin_row_' . $plugin_id,
			array( 'RevSliderAdmin', 'add_notice_wrap_pre' ),
			10,
			3
		);

		remove_action(
			'after_plugin_row_' . $plugin_id,
			array( 'RevSliderAdmin', 'show_purchase_notice' ),
			10,
			3
		);

		remove_action(
			'after_plugin_row_' . $plugin_id,
			array('RevSliderAdmin', 'add_notice_wrap_post' ),
			10,
			3
		);
	}

	/**
	 * Remove metabox where not needed.
	 */
	public static function remove_metabox() {
		remove_meta_box(
			'slider_revolution_metabox',
			array(
				'vc_grid_item',
				'templatera',
				'wpex_sidebars',
				'ptu',
				'ptu_tax'
			),
			'side'
		);
	}

	/**
	 * Load CSS in the admin.
	 */
	public static function enqueue_admin_styles() {
		if ( ! array_key_exists( 'page', $_GET ) || 'revslider' !==  $_GET['page'] ) {
			return;
		}
		wp_enqueue_style(
			'wpex-revslider-admin',
			wpex_asset_url( 'css/wpex-revslider-admin.css' ),
			array(),
			WPEX_THEME_VERSION
		);
	}

}