<?php
/**
 * WooCommerce Customizer Settings.
 *
 * @package TotalTheme
 * @subpackage Integration/WooCommerce
 * @version 5.4.5
 */

defined( 'ABSPATH' ) || exit;

$refresh_desc = esc_html__( 'You must save your options and refresh your live site to preview changes to this setting. You may have to also add or remove an item from the cart to clear the WooCommerce cache.', 'total' );
$refresh_desc_2 = esc_html__( 'You must save your options and refresh your live site to preview changes to this setting.', 'total' );

// General
$this->sections['wpex_woocommerce_general'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woo_custom_sidebar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Custom Sidebar', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'woo_header_product_searchform',
			'control' => array(
				'label' => esc_html__( 'Header Product Search', 'total' ),
				'type' => 'wpex_toggle',
				'description' =>  esc_html__( 'When enabled the header search function will make use of the WooCommerce search functionality to only search for products.', 'total' ),
			),
		),
		array(
			'id' => 'woo_show_og_price',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Show Original Price', 'total' ),
				'type' => 'wpex_toggle',
				'description' =>  esc_html__( 'When enabled the original price will display on sale items.', 'total' ),
			),
			'inline_css' => array(
				'target' => '.woocommerce ul.products li.product .price del,.woocommerce div.product div.summary del',
				'alter' => 'display',
				'sanitize' => 'checkbox',
			),
		),
		array(
			'id' => 'woo_sale_flash_text',
			'control' => array(
				'label' => esc_html__( 'On Sale Text', 'total' ),
				'type' => 'text',
			),
		),
	)
);

// Header Cart
$this->sections['wpex_woocommerce_menu_cart'] = array(
	'title' => esc_html__( 'Header Menu Cart', 'total' ),
	'panel' => 'wpex_woocommerce',
	'description' =>$refresh_desc,
	'settings' => array(
		array(
			'id' => 'woo_menu_icon_display',
			'default' => 'icon_count',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Menu Cart: Display', 'total' ),
				'type' => 'select',
				'choices' => array(
					'disabled' => esc_html__( 'Disabled', 'total' ),
					'icon' => esc_html__( 'Icon', 'total' ),
					'icon_total' => esc_html__( 'Icon And Cart Total', 'total' ),
					'icon_count' => esc_html__( 'Icon And Cart Count', 'total' ),
				),
			),
		),
		array(
			'id' => 'woo_menu_icon_class',
			'default' => 'shopping-cart',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Shop Icon', 'total' ),
				'type' => 'select',
				'choices' => array(
					'shopping-cart' => esc_html__( 'Shopping Cart', 'total' ),
					'shopping-cart-alt' => esc_html__( 'Shopping Cart Alt', 'total' ),
					'shopping-bag' => esc_html__( 'Shopping Bag', 'total' ),
					'shopping-bag-alt' => esc_html__( 'Shopping Bag Alt', 'total' ),
					'shopping-basket' => esc_html__( 'Shopping Basket', 'total' ),
					'shopping-basket-alt' => esc_html__( 'Shopping Basket Alt', 'total' ),
				),
			),
		),
		array(
			'id' => 'woo_menu_icon_style',
			'default' => 'drop_down',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Menu Cart: Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'drop_down' => esc_html__( 'Open Cart Dropdown', 'total' ),
					'overlay' => esc_html__( 'Open Cart Overlay', 'total' ),
					'store' => esc_html__( 'Go To Cart', 'total' ),
					'custom-link' => esc_html__( 'Custom Link', 'total' ),
				),
			),
		),
		array(
			'id' => 'woo_menu_icon_custom_link',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Menu Cart: Custom Link', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'woo_dropdown_cart_top_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Drop Down Top Border', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#current-shop-items-dropdown',
				'alter' => '--wpex-dropmenu-colored-top-border-color',
			),
			'control_display' => array(
				'check' => 'woo_menu_icon_style',
				'value' => 'drop_down',
			),
		),
		array(
			'id' => 'has_woo_mobile_menu_cart_link',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Cart Link', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'When enabled the cart link will display in the mobile menu as well.', 'total' ),
			),
			'control_display' => array(
				'check' => 'woo_menu_icon_display',
				'value' => 'disabled',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'wpex_woo_menu_icon_bubble',
			'transport' => 'postMessage',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Cart Count Bubble', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to display the cart number inside a colored circle.', 'total' ),
			),
			'control_display' => array(
				'check' => 'woo_menu_icon_display',
				'value' => 'icon_count',
			),
		),
		array(
			'id' => 'wpex_woo_menu_icon_bubble_bg',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Cart Count Bubble Background', 'total' ),
				'type' => 'color',
			),
			'control_display' => array(
				'check' => 'wpex_woo_menu_icon_bubble',
				'value' => 'true',
			),
			'inline_css' => array(
				'target' => '.wcmenucart-details.count.t-bubble,.wpex-header-cart-icon__count--bubble',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wpex_woo_menu_icon_bubble_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Cart Count Bubble Color', 'total' ),
				'type' => 'color',
			),
			'control_display' => array(
				'check' => 'wpex_woo_menu_icon_bubble',
				'value' => 'true',
			),
			'inline_css' => array(
				'target' => '.wcmenucart-details.count.t-bubble,.wpex-header-cart-icon__count--bubble',
				'alter' => 'color',
			),
		),
	)
);

// Archives
$this->sections['wpex_woocommerce_archives'] = array(
	'title' => esc_html__( 'Shop & Archives', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woo_shop_disable_default_output',
			'control' => array(
				'label' => esc_html__( 'Custom Shop Page', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to remove the default WooCommerce archive from your main shop page.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_title',
			'default' => 'on',
			'control' => array(
				'label' => esc_html__( 'Shop Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enables the page header title for the main shop page.', 'total' ),
			),
		),
		array(
			'id' => 'woo_archive_has_page_header',
			'default' => 'on',
			'control' => array(
				'label' => esc_html__( 'Shop Archives Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enables the page header title on shop archives such as categories and tags.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_term_page_header_image_enabled',
			'control' => array(
				'label' => esc_html__( 'Page Header Background', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'When enabled the product category and tags will use the background page header style by default when a thumbnail is set just like standard categories.', 'total' ),
			),
			'control_display' => array(
				'check' => 'woo_shop_title',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_added_to_cart_notice',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Added to Cart Popup', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enables a popup when adding products to your cart via the AJAX add to cart function showing the product that was added.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_sort',
			'default' => 'on',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sort Dropdown', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'You must save your options and refresh your live site to preview changes to this setting.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_result_count',
			'default' => 'on',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Results Count', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'You must save your options and refresh your live site to preview changes to this setting.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_posts_per_page',
			'default' => '12',
			'control' => array(
				'label' => esc_html__( 'Products Per Page', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'You must save your options and refresh your live site to preview changes to this setting.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_layout',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'woocommerce_shop_columns',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Columns', 'total' ),
				'type' => 'wpex-columns',
			),
		),
		array(
			'id' => 'woo_shop_columns_gap',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => wpex_column_gaps(),
			),
		),
		array(
			'id' => 'woo_category_description_position',
			'default' => 'under_title',
			'control' => array(
				'label' => esc_html__( 'Category Description Position', 'total' ),
				'type' => 'select',
				'choices' => array(
					''			  => esc_html__( 'Default', 'total' ),
					'under_title' => esc_html__( 'Under Title', 'total' ),
					'above_loop' => esc_html__( 'Before Entries', 'total' ),
				),

			),
		),
		// Entry settings
		array(
			'id' => 'woo_entry_settings_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Product Entry', 'total' ),
			),
		),
		array(
			'id' => 'woo_show_entry_title',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Entry Title', 'total' ),
				'type' => 'wpex_toggle',
			),
			'inline_css' => array(
				'target' => '.woocommerce ul.products li.product .woocommerce-loop-product__title',
				'alter' => 'display',
				'sanitize' => 'checkbox',
			),
		),
		array(
			'id' => 'woo_show_entry_rating',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Entry Rating', 'total' ),
				'type' => 'wpex_toggle',
			),
			'inline_css' => array(
				'target' => '.woocommerce ul.products li.product .star-rating',
				'alter' => 'display',
				'sanitize' => 'checkbox',
			),
		),
		array(
			'id' => 'woo_show_entry_price',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Entry Price', 'total' ),
				'type' => 'wpex_toggle',
			),
			'inline_css' => array(
				'target' => '.woocommerce ul.products li.product .price',
				'alter' => 'display',
				'sanitize' => 'checkbox',
			),
		),
		array(
			'id' => 'woo_show_entry_add_to_cart',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Add to Cart Button', 'total' ),
				'type' => 'wpex_toggle',
			),
			'inline_css' => array(
				'target' => '.woocommerce ul.products li.product a.button',
				'alter' => 'display',
				'sanitize' => 'checkbox',
			),
		),
		array(
			'id' => 'woo_entry_equal_height',
			'control' => array(
				'label' => esc_html__( 'Bottom Align Buttons', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'woo_default_entry_buttons',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_default_entry_buttons',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Always Visible Add to Cart Button', 'total' ),
				'type' => 'wpex_toggle',
				'description' => $refresh_desc_2,
			),
		),
		array(
			'id' => 'woo_entry_align',
			'control' => array(
				'label' => esc_html__( 'Entry Alignment', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default','total' ),
					'left' => esc_html__( 'Left','total' ),
					'right' => esc_html__( 'Right','total' ),
					'center' => esc_html__( 'Center','total' ),
				),
			),
		),
		array(
			'id' => 'woo_product_entry_style',
			'default' => 'image-swap',
			'control' => array(
				'label' => esc_html__( 'Entry Media Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'featured-image' => esc_html__( 'Featured Image', 'total' ),
					'image-swap' => esc_html__( 'Image Swap', 'total' ),
					'gallery-slider' => esc_html__( 'Gallery Slider', 'total' ),
				),
			),
		),
	)
);

// Single
$this->sections['wpex_woocommerce_single'] = array(
	'title' => esc_html__( 'Single Product', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woo_product_has_page_header',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_page_header',
			),
		),
		array(
			'id' => 'woo_show_post_rating',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Product Rating', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'woo_next_prev',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Next & Previous Links', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'woo_product_meta',
			'default' => 'on',
			'control' => array(
				'label' => esc_html__( 'Product Meta', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Categories, Tags, SKU, etc.', 'total' ),
			),
		),
		array(
			'id' => 'woo_shop_single_title',
			'default' => esc_html__( 'Store', 'total' ),
			'control' => array(
				'label' => esc_html__( 'Page Header Title Text', 'total' ),
				'type' => 'text',
			),
			'control_display' => array(
				'check' => 'woo_product_has_page_header',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_layout',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'woo_product_gallery_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Product Gallery Width', 'total' ),
				'type' => 'wpex_length_unit',
				'default_unit' => '%',
				'placeholder' => '52',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-woo-product-gallery-width',
			),
		),
		array(
			'id' => 'woo_product_summary_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Product Summary Width', 'total' ),
				'type' => 'wpex_length_unit',
				'default_unit' => '%',
				'placeholder' => '44',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-woo-product-summary-width',
			),
		),
		array(
			'id' => 'woocommerce_upsells_count',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Up-Sells Count', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter 0 to disable.', 'total' ),
			),
		),
		array(
			'id' => 'woocommerce_upsells_columns',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Up-Sells Columns', 'total' ),
				'type' => 'wpex-columns',
			),
		),
		array(
			'id' => 'woocommerce_related_count',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Related Items Count', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter 0 to disable.', 'total' ),
			),
		),
		array(
			'id' => 'woocommerce_related_columns',
			'default' => '4',
			'control' => array(
				'label' => esc_html__( 'Related Products Columns', 'total' ),
				'type' => 'wpex-columns',
			),
		),
	),
);

// Gallery
$this->sections['wpex_woocommerce_product_gallery'] = array(
	'title' => esc_html__( 'Single Product Gallery', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woo_product_gallery_slider',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Product Gallery Slider', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'woo_product_gallery_slider_arrows',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Product Gallery Slider Arrows', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'woo_product_gallery_slider',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_gallery_zoom',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Product Image Zoom', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enables zooming on the product images while hovering.', 'total' ),
			),
		),
		array(
			'id' => 'woo_product_gallery_slider_animation_speed',
			'default'  => '600',
			'control' => array(
				'label' => esc_html__( 'Product Gallery Slider Animation Speed', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter a value in milliseconds.', 'total' )
			),
			'control_display' => array(
				'check' => 'woo_product_gallery_slider',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_gallery_lightbox',
			'default' => 'total',
			'control' => array(
				'label' => esc_html__( 'Product Gallery Lightbox', 'total' ),
				'type' => 'select',
				'choices' => array(
					'disabled' => esc_html__( 'Disabled', 'total' ),
					'total' => esc_html__( 'Theme Lightbox', 'total' ),
					'woo' => esc_html__( 'WooCommerce Lightbox', 'total' ),
				),
			),
		),
		array(
			'id' => 'woo_product_gallery_lightbox_titles',
			'control' => array(
				'label' => esc_html__( 'Lightbox Titles', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'woo_product_gallery_lightbox',
				'value' => 'total',
			),
		),
		array(
			'id' => 'woocommerce_gallery_thumbnails_count',
			'default' => 5,
			'control' => array(
				'label' => esc_html__( 'Gallery Thumbnails Columns', 'total' ),
				'type' => 'select',
				'choices' => array(
					'1' => 1,
					'2' => 2,
					'3' => 3,
					'4' => 4,
					'5' => 5,
					'6' => 6,
				),
			),
		),
		array(
			'id' => 'woocommerce_gallery_thumbnails_gap',
			'transport' => 'refresh',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Gallery Thumbnails Gap', 'total' ) . ' (px)',
				'input_attrs' => array(
					'placeholder' => '8px',
				),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-woo-product-gallery-thumbs-gap',
				'sanitize' => 'px',
			),
		),
	),
);

// Tabs
$this->sections['wpex_woocommerce_tabs'] = array(
	'title' => esc_html__( 'Single Product Tabs', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woo_product_tabs_position',
			'default' => '',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Product Tabs Position', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'right' => esc_html__( 'Next to Image', 'total' ),
				),
				'description' => $refresh_desc_2,
			),
		),
		array(
			'id' => 'woo_product_accordion_tabs',
			'control' => array(
				'label' => esc_html__( 'Accordion Tabs', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Converts the default WooCommerce tabs into an Accordion.', 'total' ),
			),
		),
		array(
			'id' => 'woo_product_accordion_tabs_animate',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Animate Accordion', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_accordion_tabs_first_open',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Open First Accordion', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_accordion_tab_title_tag',
			'default' => 'h3',
			'control' => array(
				'label' => esc_html__( 'Accordion Title HTML Tag', 'total' ),
				'type' => 'select',
				'choices' => 'html_tag',
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_accordion_icon_type',
			'default' => 'plus',
			'control' => array(
				'label' => esc_html__( 'Accordion Icon Type', 'total' ),
				'type' => 'select',
				'choices' => array(
					'plus' => esc_html__( 'Plus', 'total' ),
					'angle' => esc_html__( 'Angle', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_responsive_tabs',
			'control' => array(
				'label' => esc_html__( 'Expanded Tabs on Mobile', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Hides the single product tab links and displays the content vertically with headings on devices smaller than 768px.', 'total' ),
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'false',
			),
		),
		array(
			'id' => 'woo_product_tab_title_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Tab Title Font Size', 'total' )
			),
			'inline_css' => array(
				'target' => '.wpex-woo-product-accordion .vcex-toggle__heading,.woocommerce-tabs .wc-tabs li a',
				'alter' => 'font-size',
			),
		),
		array(
			'id' => 'woo_product_accordion_title_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Accordion Title Color', 'total' )
			),
			'inline_css' => array(
				'target' => '.wpex-woo-product-accordion .vcex-toggle__heading',
				'alter' => 'color',
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'true',
			),
		),
		array(
			'id' => 'woo_product_accordion_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Accordion Border Color', 'total' )
			),
			'inline_css' => array(
				'target' => '.wpex-woo-product-accordion .vcex-toggle',
				'alter' => '--wpex-border-main',
			),
			'control_display' => array(
				'check' => 'woo_product_accordion_tabs',
				'value' => 'true',
			),
		),
	),
);

// Social Share Buttons
$this->sections['wpex_woocommerce_social_share'] = array(
	'title' => esc_html__( 'Social Share Buttons', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'social_share_woo',
			'control' => array(
				'label' => esc_html__( 'Social Share', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'woo_social_share_label',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Labels', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'woo_product_social_share_style',
				'value' => array( 'flat', 'minimal', 'three-d', 'rounded', 'custom' ),
			),
		),
		array(
			'id' => 'woo_product_social_share_location',
			'control' => array(
				'label' => esc_html__( 'Location', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'woocommerce_share' => esc_html__( 'With Main Details', 'total' ),
				),
			),
		),
		array(
			'id' => 'woo_product_social_share_heading',
			'default' => esc_html__( 'Share This', 'total' ),
			'control' => array(
				'label' => esc_html__( 'Heading Text', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Leave blank to disable.', 'total' ),
			),
		),
		array(
			'id' => 'woo_product_social_share_style',
			'default' => 'flat',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'flat' => esc_html__( 'Flat', 'total' ),
					'minimal' => esc_html__( 'Minimal', 'total' ),
					'three-d' => esc_html__( '3D', 'total' ),
					'rounded' => esc_html__( 'Rounded', 'total' ),
					'mag' => esc_html__( 'Magazine', 'total' ),
					'custom' => esc_html__( 'Custom', 'total' ),
				),
			),
		),
	),
);

// Cart
$this->sections['wpex_woocommerce_cart'] = array(
	'title' => esc_html__( 'Cart', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woocommerce_cross_sells_count',
			'default' => '2',
			'control' => array(
				'label' => esc_html__( 'Cross-Sells Count', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter 0 to disable.', 'total' ),
			),
		),
		array(
			'id' => 'woocommerce_cross_sells_columns',
			'default' => '2',
			'control' => array(
				'label' => esc_html__( 'Cross-Sells Columns', 'total' ),
				'type' => 'wpex-columns',
			),
		),
	),
);

// Checkout
$this->sections['wpex_woocommerce_checkout'] = array(
	'title' => esc_html__( 'Checkout', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'woo_checkout_single_col',
			'control' => array(
				'label' => esc_html__( 'Single Column Checkout', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'woo_checkout_order_review_placement',
			'default' => 'right_col',
			'control' => array(
				'label' => esc_html__( 'Order Review Placement', 'total' ),
				'type' => 'select',
				'choices' => array(
					'right_col' => esc_html__( 'Right Column (below additonal information)', 'total' ),
					'left_col' => esc_html__( 'After Columns (below billing and additional information)', 'total' ),
				),
			),
		),
	),
);

// Styling
$this->sections['wpex_woocommerce_styling'] = array(
	'title' => esc_html__( 'Styling', 'total' ),
	'panel' => 'wpex_woocommerce',
	'settings' => array(
		array(
			'id' => 'onsale_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'On Sale Tag Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '.woocommerce span.onsale',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'onsale_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'On Sale Tag Color', 'total' )
			),
			'inline_css' => array(
				'target' => '.woocommerce span.onsale',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'woo_onsale_border_radius',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', 'em', 'rem', '%', 'var' ),
				'label' => esc_html__( 'On Sale Tag Border Radius', 'total' )
			),
			'inline_css' => array(
				'target' => '.woocommerce span.onsale, .woocommerce .outofstock-badge',
				'alter' => 'border-radius',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'woo_onsale_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'label' => esc_html__( 'On Sale Tag Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '.woocommerce span.onsale, .woocommerce .outofstock-badge',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'woo_add_to_cart_popup_button_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Hover Add to Cart Button Background', 'total' )
			),
			'inline_css' => array(
				'target' => '.wpex-loop-product-add-to-cart',
				'alter' => '--wpex-woo-btn-bg',
			),
		),
		array(
			'id' => 'woo_add_to_cart_popup_button_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Hover Add to Cart Button Gutter', 'total' ),
				'description' => esc_html__( 'Can be used to add spacing around the button.', 'total' ),
			),
			'inline_css' => array(
				'target' => '.wpex-loop-product-add-to-cart',
				'alter' => '--wpex-woo-btn-gutter',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'woo_product_title_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Product Entry Title Color', 'total' )
			),
			'inline_css' => array(
				'target' => array(
					'.woocommerce ul.products li.product .woocommerce-loop-product__title,.woocommerce ul.products li.product .woocommerce-loop-category__title',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'woo_product_title_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Product Entry Title Color: Hover', 'total' )
			),
			'inline_css' => array(
				'target' => array(
					'.woocommerce ul.products li.product .woocommerce-loop-product__title:hover,.woocommerce ul.products li.product .woocommerce-loop-category__title:hover',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'woo_price_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Global Price Color', 'total' )
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-woo-price-color',
			),
		),
		array(
			'id' => 'woo_product_entry_price_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Product Entry Price Color', 'total' )
			),
			'inline_css' => array(
				'target' => 'li.product .price',
				'alter' => '--wpex-woo-price-color',
			),
		),
		array(
			'id' => 'woo_single_price_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Single Product Price Color', 'total' )
			),
			'inline_css' => array(
				'target' => '.product .summary',
				'alter' => '--wpex-woo-price-color',
			),
		),
		array(
			'id' => 'woo_stars_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Star Ratings Color', 'total' )
			),
			'inline_css' => array(
				'target' => array(
					'.woocommerce p.stars',
					'.woocommerce .star-rating',
				),
				'alter' => '--wpex-star-rating-color',
			),
		),
		array(
			'id' => 'woo_single_tabs_active_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Product Tabs Active Border Color', 'total' )
			),
			'inline_css' => array(
				'target' => array(
					'.woocommerce div.product .woocommerce-tabs ul.tabs li.active a',
				),
				'alter' => 'border-color',
			),
		),
	),
);