<?php
namespace TotalTheme\Integration\WPBakery;

defined( 'ABSPATH' ) || exit;

/**
 * CSS Based Full Width Elements for WPBakery.
 *
 * @package TotalTheme
 * @subpackage Integration\WPBakery
 * @version 5.4
 */
final class Full_Width {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Shortcodes to add overlay settings to.
	 *
	 * @access private
	 * @var array $shortcodes
	 */
	private static $shortcodes = array();

	/**
	 * Create or retrieve the instance of Disable_About_Screen.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}
		return static::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'wp', __CLASS__ . '::init' ); // we hook into wp to make sure post meta checks work!
	}

	/**
	 * Constructor.
	 */
	public static function init() {
		if ( ! self::is_enabled() ) {
			return;
		}
		add_filter( 'shortcode_atts_vc_section', __CLASS__ . '::parse_attributes', PHP_INT_MAX );
		add_filter( 'shortcode_atts_vc_row', __CLASS__ . '::parse_attributes', PHP_INT_MAX );
		add_filter( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, __CLASS__ . '::modify_shortcode_classes', 10, 3 );
	}

	/**
	 * Check if the element is set to full width.
	 */
	private static function is_enabled() {
		if ( 'boxed' === wpex_site_layout() || wpex_has_sidebar() ) {
			return false;
		}

		$check = get_theme_mod( 'wpb_full_width_css_enable', true );

		/**
		 * Checks whether the CSS only stretched rows funciton is enabled.
		 *
		 * @param bool $check
		 */
		$check = (bool) apply_filters( 'wpex_wpb_full_width_css', $check );
		return $check;
	}

	/**
	 * Parse VC section attributes on front-end.
	 */
	public static function parse_attributes( $atts ) {
		if ( self::shortcode_is_full_width( $atts ) && self::shortcode_supports_css_full_width( $atts ) ) {
			$atts['wpex_full_width'] = self::get_full_width_style( $atts );
			$atts['full_width'] = '';
		}
		return $atts;
	}

	/**
	 * Parse VC section attributes on front-end.
	 */
	public static function modify_shortcode_classes( $class_string, $tag, $atts ) {
		if ( ! in_array( $tag, array( 'vc_section', 'vc_row' ) ) || empty( $atts['wpex_full_width'] ) ) {
			return $class_string;
		}
		switch ( $atts['wpex_full_width'] ) {
			case 'stretch_row':
				$style = 'centered';
				break;
			case 'stretch_row_content_no_spaces':
				$style = 'no-padding';
				break;
		}
		switch ( $tag ) {
			case 'vc_section':
				$class_string .= ' wpex-vc-full-width-section';
				if ( ! empty( $style ) ) {
					$class_string .= ' wpex-vc-full-width-section--' . $style;
				}
				break;
			case 'vc_row':
				$class_string .= ' wpex-vc-full-width-row';
				if ( ! empty( $style ) ) {
					$class_string .= ' wpex-vc-full-width-row--' . $style;
				}
				break;
		}
		return $class_string;
	}

	/**
	 * Check if the element is set to full width.
	 */
	private static function shortcode_is_full_width( $atts ) {
		return (bool) self::get_full_width_style( $atts );
	}

	/**
	 * Make sure the row can be set to stretch with pure CSS.
	 */
	private static function shortcode_supports_css_full_width( $atts ) {
		$check = true;
		/*if ( ! empty( $atts['gap'] ) && '0' !== $atts['gap'] ) {
			return false;
		}*/
		if ( ! empty( $atts['css'] )
			&& preg_match('/margin-left|margin-right|padding-left|padding-right/i', $atts['css'])
		) {
			$check = false;
		}

		/**
		 * Filters whether the current shortcode supports css full width rows.
		 *
		 * @param bool $check
		 * @param array $shortcode_attributes
		 */
		$check = apply_filters( 'wpex_wpb_shortcode_supports_css_full_width', $check, $atts );

		return $check;
	}

	/**
	 * Returns full-width style.
	 */
	private static function get_full_width_style( $atts ) {
		$style = $atts['full_width'] ?? null;
		return $style;
	}

}