<?php
namespace TotalTheme\Portfolio;

defined( 'ABSPATH' ) || exit;

/**
 * Portfolio Single Blocks.
 *
 * @package TotalTheme
 * @subpackage Portfolio
 * @version 5.4.2
 */
class Single_Blocks {

	/**
	 * Returns the array of portfolio single blocks.
	 */
	public static function choices() {
		$choices = array(
			'title'    => esc_html__( 'Post Title', 'total' ),
			'meta'     => esc_html__( 'Post Meta', 'total' ),
			'media'    => esc_html__( 'Media', 'total' ),
			'content'  => esc_html__( 'Content', 'total' ),
			'details'  => esc_html__( 'Project Details', 'total' ),
			'share'    => esc_html__( 'Social Share Buttons', 'total' ),
			'comments' => esc_html__( 'Comments', 'total' ),
			'related'  => esc_html__( 'Related Posts', 'total' ),
		);

		/**
		 * Filters the list of single blocks allowed for portfolio posts.
		 *
		 * @param array $choices
		 * @param string $instance
		 */
		$choices = (array) apply_filters( 'wpex_portfolio_single_blocks', $choices, 'customizer' );

		return $choices;
	}

	/**
	 * Returns portfolio post blocks to display.
	 */
	public static function get() {
		$default_blocks = array(
			'content',
			'share',
			'related'
		);

		$blocks = get_theme_mod( 'portfolio_post_composer' ) ?: $default_blocks;

		if ( is_string( $blocks ) ) {
			$blocks = $blocks ? explode( ',', $blocks ) : array();
		}

		if ( $blocks ) {

			/*
			 * Make sure only blocks registered to be selected in the customizer can render when
			 * pulled from the theme_mod.
			 */
			$blocks = array_intersect( $blocks, array_keys( self::choices() ) );
		}

		// Set keys equal to vars for easier unsetting via hooks.
		$blocks = array_combine( $blocks, $blocks );

		/**
		 * Filters the single portfolio blocks.
		 *
		 * @param array $blocks
		 */
		$blocks = (array) apply_filters( 'wpex_portfolio_single_blocks', $blocks, 'front-end' );

		return $blocks;
	}

	/**
	 * Render Portfolio post blocks.
	 */
	public static function render() {
		$blocks = self::get();

		if ( empty( $blocks ) || ! is_array( $blocks ) ) {
			return;
		}

		foreach ( $blocks as $block ) {
			if ( 'the_content' !== $block && is_callable( $block ) ) {
				call_user_func( $block );
			} else {
				get_template_part( 'partials/portfolio/portfolio-single-' . $block );
			}
		}
	}

	/**
	 * Echo class attribute for the single portfolio blocks wrapper element.
	 */
	public static function wrapper_class() {
		$class = array(
			'wpex-first-mt-0',
			'wpex-clr',
		);

		/**
		 * Filters the portfolio post blocks element class.
		 *
		 * @param array $class
		 */
		$class = (array) apply_filters( 'wpex_portfolio_single_blocks_class', $class );

		if ( $class ) {
			echo 'class="' . esc_attr( implode( ' ', array_unique( $class ) ) ) . '"';
		}
	}

}