<?php
namespace TotalThemeCore\Shortcodes;

defined( 'ABSPATH' ) || exit;

final class Shortcode_Header_Search_Icon {

	/**
	 * Register the shortcode and add filters.
	 */
	public function __construct() {
		add_shortcode( 'header_search_icon', __CLASS__ . '::output' );
	}

	/**
	 * Shortcode output.
	 */
	public static function output( $atts = array() ) {
		if ( ! function_exists( 'wpex_header_menu_search_style' ) || 'disabled' === wpex_header_menu_search_style() ) {
			return;
		}

		$atts = shortcode_atts( array(
			'style'          => 'default',
			'class'          => '',
			'visibility'     => '',
			'label'          => '',
			'label_margin'   => '',
			'label_position' => 'right',
		), $atts, 'header_search_icon' );

		$class = '';
		$style = ! empty( $atts['style'] ) ? $atts['style'] : 'default';
		$label = self::get_label( $atts );

		if ( ! empty( $atts['class'] ) ) {
			$class .= ' ' . str_replace( '.', '', trim( $atts['class'] ) );
		}

		if ( ! empty( $atts['visibility'] ) ) {
			$visibility = $atts['visibility'];
			if ( function_exists( 'wpex_visibility_class' ) ) {
				$visibility = wpex_visibility_class( $visibility );
			}
			$class .= ' ' . sanitize_html_class( $visibility );
		}

		$aria_controls = '';

		// Begin element output.
		$html = '<span class="wpex-header-search-icon wpex-header-search-icon--style-' . sanitize_html_class( $style ) . ' wpex-inline-block' . esc_attr( $class ) . '">';

			// Button output.
			$button_class      = 'wpex-header-search-icon__button';
			$button_inline_css = '';

			if ( empty( $atts['style'] ) || 'default' === $atts['style'] ) {
				$button_class .= ' wpex-unstyled-button wpex-hover-link-color';
			}

			if ( $label ) {
				$button_class .= ' wpex-flex wpex-items-center';
				if ( ! empty( $atts['label_position'] ) && 'left' === $atts['label_position'] ) {
					$button_class .= ' wpex-flex-row-reverse';
				}
				if ( ! empty( $atts['label_margin'] ) ) {
					if ( is_numeric( $atts['label_margin'] ) ) {
						$atts['label_margin'] = $atts['label_margin'] . 'px';
					}
					$button_inline_css = ' style="gap:' . esc_attr( $atts['label_margin'] ) . ';"';
				} else {
					$button_class .= ' wpex-gap-10';
				}
			}

			$html .= '<button class="' . esc_attr( $button_class ) . '" aria-expanded="false" aria-controls="' . esc_attr( $aria_controls ) . '"' . $button_inline_css . '>';

				// Display icon.
				if ( function_exists( 'wpex_theme_icon_html' ) ) {
					$icon = wpex_get_theme_icon_html( 'search' );

					/**
					 * Filters the icon html.
					 *
					 * @param string $html
					 */
					$icon = apply_filters( 'wpex_header_search_icon_shortcode_icon_html', $icon );

					$html .= '<span class="wpex-header-search-icon__icon">' . $icon . '</span>';
				}

				// Display label.
				if ( $label ) {
					$html .= $label;
				}

			$html .= '</button>';
		$html .= '</span>';

		return $html;
	}

	/**
	 * Get label.
	 */
	public static function get_label( $atts ) {
		if ( empty( $atts['label'] ) ) {
			return;
		}
		return '<span class="wpex-header-search-icon__label">' . esc_html( $atts['label'] ) . '</span>';
	}

}