<?php
namespace TotalThemeCore\Vcex\Carousel;

defined( 'ABSPATH' ) || exit;

/**
 * Generates Inline CSS for carousels.
 *
 * @package TotalThemeCore
 * @version 1.4.6
 */

final class Inline_CSS {

	/**
	 * Unique Classname.
	 */
	protected $classname = '';

	/**
	 * CSS.
	 */
	protected $css = '';

	/**
	 * Settings.
	 */
	protected $settings = array();

	/**
	 * Check if we fail to write complete CSS for the carousel.
	 */
	protected $fails = false;

	/**
	 * Renders CSS.
	 */
	public function __construct( $class = '', $settings = array() ) {
		$this->parse_settings( $settings );
		$this->classname    = $class;
		$this->css          = '';
	}

	/**
	 * Renders CSS.
	 */
	public function render() {
		$center    = wp_validate_boolean( $this->settings['center'] ?? false );
		$autoWidth = wp_validate_boolean( $this->settings['autoWidth'] ?? false );
		if ( $center || $autoWidth ) {
			return;
		}
		if ( ! empty( $this->settings['margin'] ) ) {
			$this->css .= $this->var_css( '--wpex-carousel-gap', absint( $this->settings['margin'] ) . 'px' );
		}
		$this->css .= $this->generate_responsive_css();
		if ( $this->css && ! $this->fails ) {
			echo '<style>' . wp_strip_all_tags( $this->css ) . '</style>';
		}
	}

	/**
	 * Parse settings.
	 */
	protected function parse_settings( $settings = array() ) {
		if ( is_string( $settings ) ) {
			$this->settings = json_decode( htmlspecialchars_decode( $settings ), true );
			return;
		}
		if ( is_array( $settings ) ) {
			return $this->settings;
		}
	}

	/**
	 * Generates var css.
	 */
	protected function var_css( $var = '', $value = '' ) {
		return '.' . $this->classname . '{' . $var . ':' . esc_attr( $value ) . ';}';
	}

	/**
	 * Generates CSS to hide slides.
	 */
	protected function hide_slides( $items = 0 ) {
		$items = absint( $items );
		if ( $items ) {
			$items = $items + 1;
			$css = '.' . $this->classname . '.wpex-carousel:not(.owl-loaded) > *:not(:nth-child(1n+' . $items . ')) {display: flex !important;}';
			return $css;
		}
	}

	/**
	 * Generates responsive css.
	 */
	protected function generate_responsive_css() {
		if ( ! empty( $this->settings['itemsMobilePortrait'] )
			&& is_numeric( $this->settings['itemsMobilePortrait'] )
		) {
			$this->css .= $this->var_css( '--wpex-carousel-columns', absint( $this->settings['itemsMobilePortrait'] ) );
			$this->css .= $this->hide_slides( $this->settings['itemsMobilePortrait'] );
		} else {
			$this->fails = true;
		}

		if ( ! empty( $this->settings['itemsMobileLandscape'] )
			&& is_numeric( $this->settings['itemsMobilePortrait'] )
		) {
			$ml_css = $this->var_css( '--wpex-carousel-columns', absint( $this->settings['itemsMobileLandscape'] ) );
			$ml_css .= $this->hide_slides( $this->settings['itemsMobileLandscape'] );
			$this->css .= $this->media_query( 480, $ml_css );
		} else {
			$this->fails = true;
		}

		if ( ! empty( $this->settings['itemsTablet'] )
			&& is_numeric( $this->settings['itemsMobilePortrait'] )
		) {
			$t_css = $this->var_css( '--wpex-carousel-columns', absint( $this->settings['itemsTablet'] ) );
			$t_css .= $this->hide_slides( $this->settings['itemsTablet'] );
			$this->css .= $this->media_query( 768, $t_css );
		} else {
			$this->fails = true;
		}

		if ( ! empty( $this->settings['items'] )
			&& is_numeric( $this->settings['itemsMobilePortrait'] )
		) {
			$d_css = $this->var_css( '--wpex-carousel-columns', absint( $this->settings['items'] ) );
			$d_css .= $this->hide_slides( $this->settings['items'] );
			$this->css .= $this->media_query( 960, $d_css );
		} else {
			$this->fails = true;
		}
	}

	/**
	 * Wrap in media query.
	 */
	protected function media_query( $breakpoint = '', $css = '' ) {
		if ( ! $css ) {
			return;
		}
		return '@media only screen and (min-width: ' . $breakpoint . 'px) {' . $css . '}';
	}

}