<?php
/**
 * vcex_post_excerpt shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.4.5
 */

defined( 'ABSPATH' ) || exit;

$atts    = vcex_shortcode_atts( 'vcex_post_excerpt', $atts, 'VCEX_Post_Excerpt_Shortcode' );
$html    = '';
$excerpt = get_the_excerpt( get_post( vcex_get_the_ID() ) );

if ( empty( $excerpt ) ) {
	return;
}

$shortcode_class = array(
	'vcex-module',
	'vcex-post-excerpt',
	'wpex-last-mb-0',
);

// Custom user classes.
$extra_classes = vcex_get_shortcode_extra_classes( $atts, 'vcex_post_excerpt' );

if ( $extra_classes ) {
	$shortcode_class = array_merge( $shortcode_class, $extra_classes );
}

// Filters shortcode classes.
$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_post_excerpt', $atts );

// Inline styles.
$shortcode_style = vcex_inline_style( array(
	'color'              => $atts['color'] ?? '',
	'font_family'        => $atts['font_family'] ?? '',
	'font_size'          => $atts['font_size'] ?? '',
	'line_height'        => $atts['line_height'] ?? '',
	'font_weight'        => $atts['font_weight'] ?? '',
	'text_transform'     => $atts['text_transform'] ?? '',
	'letter_spacing'     => $atts['letter_spacing'] ?? '',
	'animation_delay'    => $atts['animation_delay'] ?? '',
	'animation_duration' => $atts['animation_duration'] ?? '',
), true );

// Begin output.
$html .= '<div class="' . esc_attr( trim( $shortcode_class ) ) . '"' . $shortcode_style . '>';

	$html .= wpautop( wp_kses_post( $excerpt ) );

$html .= '</div>';

// @codingStandardsIgnoreLine
echo $html;