<?php
namespace TotalThemeCore\WPBakery\Map;

use \VCEX_Toggle_Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Class registers the vcex_toggle shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.5
 */
final class Vcex_Toggle {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function init_hooks() {
		add_action( 'vc_after_mapping', array( $this, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( 'vcex_toggle', array( $this, 'map' ) );
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return array(
			'name'             => esc_html__( 'Toggle (FAQ)', 'total-theme-core' ),
			'description'      => esc_html__( 'Show/hide text toggle', 'total-theme-core' ),
			'base'             => 'vcex_toggle',
			'icon'             => 'vcex_element-icon vcex_element-icon--toggle',
			'category'         => vcex_shortcodes_branding(),
			'params'           => VCEX_Toggle_Shortcode::get_params(),
			'admin_enqueue_js' => vcex_wpbakery_asset_url( 'js/backend-editor/vcex-toggle-view.min.js' ),
			'js_view'          => 'vcexToggleView',
		);
	}

}