/*jshint esversion: 6 */
( function( api, $ ) {

	'use strict';

	/******** Helpers *********/

	const isValidHTMLTag = ( tag ) => {
		return document.createElement(tag).toString() != "[object HTMLUnknownElement]";
	};

	const alterElementHtmlTag = ( element, tag ) => {
		if ( ! isValidHTMLTag( tag ) ) {
			return;
		}
		document.querySelectorAll( '.sidebar-box .widget-title' ).forEach( (heading) => {
			const newEl = document.createElement( tag );
			newEl.innerHTML = heading.innerHTML;
			for (let name of heading.getAttributeNames()) {
				newEl.setAttribute( name, heading.getAttribute(name) );
			}
			newEl.setAttribute( 'id', heading.getAttribute( 'id' ) );
			heading.parentNode.replaceChild( newEl, heading );
		} );
	};

	/******** General Settings *********/

		// Pagination alignment class.
		api( 'pagination_align', function( setting ) {
			setting.bind( function( newval ) {
				document.querySelectorAll( '.wpex-pagination, .woocommerce-pagination' ).forEach( function( pagination ) {
					pagination.classList.remove( 'textcenter', 'textleft', 'textright' );
					pagination.classList.add( 'text' + newval );
				} );
			} );
		} );

		// Pagination arrow.
		api( 'pagination_arrow', function( setting ) {
			setting.bind( function( newval ) {
				var next,prev;
				if ( document.body.classList.contains( 'rtl' ) ) {
					next = document.querySelector( 'ul.page-numbers .next .ticon' );
					prev = document.querySelector( 'ul.page-numbers .prev .ticon' );
				} else {
					prev = document.querySelector( 'ul.page-numbers .next .ticon' );
					next = document.querySelector( 'ul.page-numbers .prev .ticon' );
				}
				if ( next ) {
					next.className = 'ticon ticon-' + newval + '-left';
				}
				if ( prev ) {
					prev.className = 'ticon ticon-' + newval + '-right';
				}
			} );
		} );

		// Theme heading alignment.
		api( 'theme_heading_align', function( setting ) {
			setting.bind( function( newval ) {
				document.querySelectorAll( '.theme-heading' ).forEach( function( heading ) {
					heading.classList.remove( 'wpex-text-left', 'wpex-text-center', 'wpex-text-right' );
					heading.classList.add( 'wpex-text-' + newval );
				} );
			} );
		} );

	/******** Layout Settings *********/

	api( 'boxed_dropdshadow', function( setting ) {
		setting.bind( function( newval ) {
			if ( newval ) {
				document.body.classList.add( 'wrap-boxshadow' );
			} else {
				document.body.classList.remove( 'wrap-boxshadow' );
			}
		} );
	} );

	api( 'header_flex_items', function( setting ) {
		setting.bind( function( newval ) {
			var header = document.querySelector( '#site-header' );
			if ( ! header ) {
				return;
			}
			if ( newval ) {
				header.classList.add( 'wpex-header-two-flex-v' );
			} else {
				header.classList.remove( 'wpex-header-two-flex-v' );
			}
		} );
	} );

	api( 'site_frame_border', function( setting ) {
		setting.bind( function( newval ) {
			if ( newval ) {
				document.body.classList.add( 'has-frame-border' );
			} else {
				document.body.classList.remove( 'has-frame-border' );
			}
		} );
	} );

	/******** Topbar Settings *********/

		api( 'top_bar_fullwidth', function( setting ) {
			setting.bind( function( newval ) {
				var topBarWrap = document.querySelector( '#top-bar-wrap' );
				if ( ! topBarWrap ) {
					return;
				}
				if ( newval ) {
					topBarWrap.classList.add( 'top-bar-full-width', 'wpex-px-30' );
				} else {
					topBarWrap.classList.remove( 'top-bar-full-width', 'wpex-px-30' );
				}
			} );
		} );

		api( 'top_bar_bottom_border', function( setting ) {
			setting.bind( function( newval ) {
				var topBarWrap = document.querySelector( '#top-bar-wrap' );
				if ( ! topBarWrap ) {
					return;
				}
				if ( newval ) {
					topBarWrap.classList.add( 'wpex-border-b', 'wpex-border-main', 'wpex-border-solid' );
				} else {
				   topBarWrap.classList.remove( 'wpex-border-b', 'wpex-border-main', 'wpex-border-solid' );
				}
			} );
		} );

	/******** Header Settings *********/

		// Full-width header
		api( 'full_width_header', function( setting ) {
			setting.bind( function( newval ) {
				var header = document.querySelector( '#site-header' );
				if ( ! header ) {
					return;
				}
				if ( newval ) {
					header.classList.add( 'header-full-width' );
				} else {
					header.classList.remove( 'header-full-width' );
				}
			} );
		} );

		// Header Vertical Style - Fixed or not fixed
		api( 'vertical_header_style', function( setting ) {
			setting.bind( function( newval ) {
				if ( newval ) {
					document.body.classList.add( 'wpex-fixed-vertical-header' );
				} else {
					document.body.classList.remove( 'wpex-fixed-vertical-header' );
				}
			} );
		} );

		// Menu Outline
		api( 'header_menu_disable_outline', function( setting ) {
			setting.bind( function( newval ) {
				var nav = document.querySelector( '.navbar-style-two, .navbar-style-three, .navbar-style-four' );
				if ( ! nav ) {
					return;
				}
				if ( newval ) {
					nav.classList.add( 'no-outline' );
				} else {
					nav.classList.remove( 'no-outline' );
				}
			} );
		} );

		// Menu Inner border
		api( 'header_menu_disable_borders', function( setting ) {
			setting.bind( function( newval ) {
				var nav = document.querySelector( '.navbar-style-two, .navbar-style-six' );
				if ( ! nav ) {
					return;
				}
				if ( newval ) {
					nav.classList.add( 'no-borders' );
				} else {
					nav.classList.remove( 'no-borders' );
				}
			} );
		} );

		// Header Center
		api( 'header_menu_center', function( setting ) {
			setting.bind( function( newval ) {
				var nav = document.querySelector( '.navbar-style-two' );
				if ( ! nav ) {
					return;
				}
				if ( newval ) {
					nav.classList.add( 'center-items' );
				} else {
					nav.classList.remove( 'center-items' );
				}
			} );
		} );

		// Header menu stretch
		api( 'header_menu_stretch_items', function( setting ) {
			setting.bind( function( newval ) {
				document.querySelectorAll( '.navbar-style-two, .navbar-style-three, .navbar-style-four, .navbar-style-five' ).forEach( function( nav ) {
					if ( newval ) {
						nav.classList.add( 'wpex-stretch-items' );
					} else {
						nav.classList.remove( 'wpex-stretch-items' );
					}
				} );
			} );
		} );

		/* Header menu active underline
		api( 'menu_active_underline', function( setting ) {
			setting.bind( function( newval ) {
				document.querySelectorAll( '#site-navigation-wrap' ).forEach( function( nav ) {
					if ( nav.classList.contains( 'navbar-style-six' ) || nav.classList.contains( 'navbar-style-dev' ) ) {
						return;
					}
					if ( newval ) {
						nav.classList.add( 'has-menu-underline' );
					} else {
						nav.classList.remove( 'has-menu-underline' );
					}
				} );
			} );
		} );
		*/

	/******** Main Menu Settings *********/

		// Menu pointer/caret.
		api( 'menu_dropdown_caret', function( setting ) {
			setting.bind( function( newval ) {
				document.querySelectorAll( '.navbar-style-one, .navbar-style-five, .navbar-style-seven, .navbar-style-eight, .navbar-style-nine' ).forEach( (navbar) => {
					if ( newval ) {
						navbar.classList.add( 'wpex-dropdowns-caret' );
					} else {
						navbar.classList.remove( 'wpex-dropdowns-caret' );
					}
				} );
			} );
		} );

		/*
		// @deprecated in 5.4 to prevent issues with menu_dropdown_caret
		api( 'menu_dropdown_style', function( setting ) {
			setting.bind( function( newval ) {
				var $siteheader = $( '#site-header' );
				if ( ! $siteheader.length ) {
					return;
				}
				var headerClasses = $siteheader.attr( 'class' ).split( ' ' );
				for(var i = 0; i < headerClasses.length; i++) {
					if ( headerClasses[i].indexOf( 'wpex-dropdown-style-' ) != -1 ) {
						$siteheader.removeClass(headerClasses[i]);
					}
				}
				$siteheader.addClass( 'wpex-dropdown-style-' + newval );
			} );
		} );*/

		api( 'menu_dropdown_dropshadow', function( setting ) {
			setting.bind( function( newval ) {
				var $siteheader = $( '#site-header' );
				if ( ! $siteheader.length ) {
					return;
				}
				var headerClasses = $siteheader.attr( 'class' ).split( ' ' );
				for(var i = 0; i < headerClasses.length; i++) {
					if(headerClasses[i].indexOf( 'wpex-dropdowns-shadow-' ) != -1) {
						$siteheader.removeClass(headerClasses[i]);
					}
				}
				$siteheader.addClass( 'wpex-dropdowns-shadow-' + newval );
			} );
		} );

	/******** Mobile Menu Settings *********/

		api( 'mobile_menu_icon_animate', function( setting ) {
			setting.bind( function( newval ) {
				var icon = document.querySelector( '.mobile-menu-toggle .wpex-hamburger-icon' );
				if ( icon ) {
					if ( newval ) {
						icon.classList.add( 'wpex-hamburger-icon--animate' );
					} else {
						icon.classList.remove( 'wpex-hamburger-icon--animate' );
					}

				}
			} );
		} );

		api( 'mobile_menu_icon_rounded', function( setting ) {
			setting.bind( function( newval ) {
				var icon = document.querySelector( '.mobile-menu-toggle .wpex-hamburger-icon' );
				if ( icon ) {
					if ( newval ) {
						icon.classList.add( 'wpex-hamburger-icon--rounded' );
					} else {
						icon.classList.remove( 'wpex-hamburger-icon--rounded' );
					}

				}
			} );
		} );

		api( 'mobile_menu_sidr_dark_surface', function( setting ) {
			setting.bind( function( newval ) {
				var el = document.querySelector( '#sidr-main' );
				console.log( el );
				if ( el ) {
					if ( newval ) {
						el.classList.add( 'wpex-surface-dark' );
					} else {
						el.classList.remove( 'wpex-surface-dark' );
					}

				}
			} );
		} );

	/******** Sidebar Settings *********/

		api( 'has_widget_icons', function( setting ) {
			setting.bind( function( newval ) {
				if ( newval ) {
					document.body.classList.add( 'sidebar-widget-icons' );
				} else {
					document.body.classList.remove( 'sidebar-widget-icons' );
				}
			} );
		} );

		api( 'sidebar_headings', function( setting ) {
			setting.bind( function( newval ) {
				alterElementHtmlTag( '.sidebar-box .widget-title', newval );
			} );
		} );

	/******** Blog Settings *********/

		api( 'blog_single_header_custom_text', function( setting ) {
			var title = document.querySelector( 'body.single-post .page-header-title' );
			if ( ! title ) {
				return;
			}
			var ogTitle = setting.get();
			setting.bind( function( newval ) {
				if ( newval ) {
					title.innerHTML = newval;
				} else {
					title.innerHTML = ogTitle;
				}
			} );
		} );

		api( 'blog_related_title', function( setting ) {
			var heading = document.querySelector( '.related-posts-title span.text' );
			if ( ! heading ) {
				return;
			}
			var ogheading = setting.get();
			setting.bind( function( newval ) {
				if ( newval ) {
					heading.innerHTML = newval;
				} else {
					heading.innerHTML = ogheading;
				}
			} );
		} );

	/******** Portfolio Settings *********/

		api( 'portfolio_related_title', function( setting ) {
			var heading = document.querySelector( '.related-portfolio-posts-heading span.text' );
			if ( ! heading ) {
				return;
			}
			var ogheading = setting.get();
			setting.bind( function( newval ) {
				if ( newval ) {
					heading.innerHTML = newval;
				} else {
					heading.innerHTML = ogheading;
				}
			} );
		} );

	/******** Staff Settings *********/

		api( 'staff_related_title', function( setting ) {
			var heading = document.querySelector( '.related-staff-posts-heading span.text' );
			if ( ! heading ) {
				return;
			}
			var ogheading = setting.get();
			setting.bind( function( newval ) {
				if ( newval ) {
					heading.innerHTML = newval;
				} else {
					heading.innerHTML = ogheading;
				}
			} );
		} );

	/******** Footer Settings *********/

		api( 'footer_dark_surface', function( setting ) {
			setting.bind( function( newval ) {
				var el = document.querySelector( '#footer' );
				if ( el ) {
					if ( newval ) {
						el.classList.add( 'wpex-surface-dark' );
					} else {
						el.classList.remove( 'wpex-surface-dark' );
					}
				}
			} );
		} );

		api( 'footer_headings', function( setting ) {
			setting.bind( function( newval ) {
				alterElementHtmlTag( '.footer-widget .widget-title', newval );
			} );
		} );

		api( 'footer_widgets_gap', function( setting ) {
			setting.bind( function( newval ) {
				var widgets = $( '#footer-widgets' );
				var classes = widgets.attr( 'class' ).split( ' ' );
				if ( classes ) {
					$.each(classes, function(i, c) {
						if ( 0 == c.indexOf( 'gap-' ) ) {
							widgets.removeClass(c);
						}
					} );
				}
				if ( newval ) {
					widgets.addClass( 'gap-' + newval );
				}
			} );
		} );

		api( 'footer_bottom_dark_surface', function( setting ) {
			setting.bind( function( newval ) {
				var el = document.querySelector( '#footer-bottom' );
				if ( el ) {
					if ( newval ) {
						el.classList.add( 'wpex-surface-dark', 'wpex-bg-gray-900' );
					} else {
						el.classList.remove( 'wpex-surface-dark', 'wpex-bg-gray-900' );
					}
				}
			} );
		} );

	/******** WooCommerce Settings *********/

		api( 'woo_menu_icon_class', function( setting ) {
			setting.bind( function( newval ) {
				document.querySelectorAll( '.wpex-header-cart-icon__icon .ticon,.wcmenucart-icon .ticon' ).forEach( function( el ) {
					el.className = 'ticon ticon-' + newval;
				} );
			} );
		} );

	/******** Inline CSS *********/

	(function () {

		if ( 'undefined' === typeof wpex_customizer_params || 'undefined' === typeof wpex_customizer_params.inline_css ) {
			return;
		}

		const retriggerStretchedRows = ( property ) => {
			if ( 'function' === typeof window.vc_rowBehaviour && ( '--wpex-container-max-width' === property || '--wpex-container-width' === property ) ) {
				setTimeout( window.vc_rowBehaviour );
			}
		};

		_.each( wpex_customizer_params.inline_css, function( cssArgs, id ) {

			api( id, function( setting ) {

				setting.bind( function( newval ) {
					let css = '';
					let target = cssArgs.target;
					let property = cssArgs.alter;

					const styleId = 'wpex-customizer-' + id; // name also used in PHP don't change.
					const styleEl = document.querySelector( '#' + styleId );
					const sanitize = cssArgs.sanitize || '';
					const important = cssArgs.important ? '!important' : '';
					const media_query = cssArgs.media_query || '';
					const ogProperty = property;

					const generateCSS = () => {
						if ( media_query ) {
							css += '@media only screen and ' + media_query + '{';
						}

						// Sanitize val.
						if ( sanitize && newval ) {

							switch( sanitize ) {
								case 'border_radius':
								case 'padding':
								case 'margin':
								case 'width':
									if ( '0' === newval ) {
										newval = '';
									} else if ( ! isNaN( newval ) ) {
										newval = parseFloat( newval ) + 'px'; // use pixels if only a number is entered.
									}
									break;
								case 'container_width':
									if ( ! isNaN( newval ) ) {
										newval = ''; // plain numbers not allowed - this is a pre 5.4 fallback fix.
									}
									break;
								case 'px':
									if ( '0' === newval ) {
										newval = ''; // this is because technically 0 can't be saved in the Customizer it returns false.
									} else {
										newval = parseFloat( newval ) + 'px';
									}
									break;
								case 'px-pct':
									if ( -1 == newval.indexOf( 'px' ) && -1 == newval.indexOf( '%' ) ) {
										newval = parseFloat( newval ) + 'px';
									}
									break;
								case 'utl_font_size':
									newval = 'var(--wpex-text-' + newval + ')';
									break;
								case 'utl_border_radius':
									if ( 'rounded-0' === newval ) {
										newval = '0px';
									} else if ( 'rounded-full' === newval ) {
										newval = '9999px';
									} else {
										newval = 'var(--wpex-' + newval + ')';
									}
									break;
								case 'fallback_px':
									if ( '0' === newval ) {
										newval = '';
									} else if ( ! isNaN( newval ) ) {
										newval = parseFloat( newval ) + 'px'; // use pixels if only a number is entered.
									}
									break;
								case 'font-size':
									if ( ! isNaN( newval ) ) {
										newval = parseFloat( newval ) + 'px'; // use pixels if only a number is entered.
									}
								break;
								default:
								// nothing.
							}

						} // End sanitize.

						// Setting is empty after sanitizing so lets remove the node.
						if ( '' === newval && styleEl ) {
							styleEl.parentNode.removeChild( styleEl );
							retriggerStretchedRows( property );
						}

						// Target single item.
						if ( 'string' === typeof property ) {

							// Add css.
							if ( Object.prototype.toString.call( target ) === '[object Array]' ) {
								$.each( target, function( index, value ) {
									css += value + '{' + property + ':' + newval + important + ';}';
								} );
							} else {
								css += target + '{' + property + ':' + newval + important + ';}';
							}

						}

						// Target multiple items.
						else {

							if ( '[object Array]' === Object.prototype.toString.call( target ) ) {
								$.each( target, function( index, value ) {
									var eachTarget = value;
									$.each( property, function( index, value ) {
										css += eachTarget + '{' + value + ':' + newval + important + ';}';
									} );
								} );
							} else {
								$.each( property, function( index, value ) {
									css += target + '{' + value + ':' + newval + important + ';}';
								} );
							}

						}

						if ( media_query ) {
							css += '}';
						}

						// Update or add CSS.
						if ( styleEl ) {
							styleEl.textContent = css;
						} else {
							var newStyle = document.createElement( 'style' );
							newStyle.id = styleId;
							newStyle.textContent = css;
							document.head.appendChild( newStyle );
						}
					};

					if ( cssArgs.value ) {
						newval = newval ? cssArgs.value : '';
					}

					if ( 'display' === property && 'checkbox' === sanitize ) {
						newval = newval ? '' : 'none';
					}

					// Setting is empty so lets just remove the inline style.
					if ( '' === newval || 'undefined' === typeof newval ) {
						if ( styleEl ) {
							styleEl.parentNode.removeChild( styleEl );
							retriggerStretchedRows( property );
						}
					} else {
						if ( 'padding' === property && -1 !== newval.indexOf(':') ) {
							newval.split('|').forEach( ( item ) => {
								let itemSplit = item.split(/:/);
								if ( 2 === itemSplit.length ) {
									property = ogProperty + '-' + itemSplit[0];
									newval =  itemSplit[1];
									generateCSS();
								}
							} );
						} else {
							generateCSS();
							retriggerStretchedRows( property );
						}
					}

				} );

			} );

		} ); // end _.each

	})();

} ( wp.customize, jQuery ) );