( function( api, l10n ) {
	'use strict';

	/**
	 * Add links.
	 */
	var addLinks = () => {
		var settings = {
			logo_text: 'wpex_typography_logo',
			header_flex_aside_content: 'wpex_typography_header_aside',
			header_aside: 'wpex_typography_header_aside',
			toggle_bar_content: 'wpex_typography_toggle_bar',
			toggle_bar_page: 'wpex_typography_toggle_bar',
			top_bar_content: 'wpex_typography_top_menu',
			page_header_style: 'wpex_typography_page_title',
			menu_link_color: 'wpex_typography_menu',
			dropdown_menu_link_color: 'wpex_typography_menu_dropdown',
			sidebar_headings: 'wpex_typography_sidebar_widget_title',
			sidebar_text_color: 'wpex_typography_sidebar',
			footer_color: 'wpex_typography_footer_widgets',
			footer_headings: 'wpex_typography_footer_widget_title',
			footer_callout_color: 'wpex_typography_callout',
			callout_text: 'wpex_typography_callout',
			footer_copyright_text: 'wpex_typography_copyright',
			bottom_footer_link_color: 'wpex_typography_footer_menu',
			breadcrumbs_text_color: 'wpex_typography_breadcrumbs',
			theme_button_padding: 'wpex_typography_button',
			mobile_menu_links: 'wpex_typography_mobile_menu',
			toggle_mobile_menu_links: 'wpex_typography_mobile_menu',
			mobile_menu_full_screen_color: 'wpex_typography_mobile_menu',
			blockquote_color: 'wpex_typography_blockquote'
		};
		Object.entries(settings).forEach(entry => {
			const [key, value] = entry;
			var label = document.querySelector('#customize-control-' + key + ' .customize-control-title');
			if ( label ) {
				label.classList.add('customize-control-title--has-wpex-focus-link');
				var focusLink = document.createElement('span');
					focusLink.className = 'wpex-customize-focus-link';
					focusLink.setAttribute( 'data-wpex-section', value );
					focusLink.setAttribute( 'data-wpex-control', key );
				var focusLinkInner = document.createElement('span');
					focusLinkInner.textContent = l10n.linkText;
				focusLink.appendChild(focusLinkInner);
				focusLink.innerHTML = '(' + focusLink.innerHTML +')';
				label.appendChild(focusLink);
			}
		});
	};

	 /**
	  * Auto Focus.
	  */
	 document.addEventListener( 'click', function( event ) {
		var link = event.target.closest( '.wpex-customize-focus-link' );
		if ( ! link ) {
			return;
		}
		event.preventDefault();
		var targetSection = link.dataset.wpexSection;
		if ( targetSection ) {
			var section = wp.customize.section( targetSection );
			if ( section ) {
				var sectionContainer = section.contentContainer[0];
				if ( sectionContainer && ! sectionContainer.querySelector( '.wpex-customize-back-link' ) ) {
					var backLinkLi = document.createElement( 'li' );
					var backLink = document.createElement( 'a' );
						backLink.textContent = l10n.backLinkText;
						backLink.setAttribute( 'href', '#' );
						backLink.setAttribute( 'data-wpex-control', link.dataset.wpexControl );
						backLink.className = 'wpex-customize-back-link';
					backLinkLi.appendChild( backLink );
					sectionContainer.firstElementChild.after( backLinkLi );
				}
				section.focus();
			}
		}
	 } );

	 /**
	  * Back Link.
	  */
	document.addEventListener( 'click', function( event ) {
		var link = event.target.closest( 'a.wpex-customize-back-link' );
		if ( ! link ) {
			return;
		}
		event.preventDefault();
		var control = wp.customize.control( link.dataset.wpexControl );
		if ( control ) {
			link.parentNode.removeChild( link );
			control.focus();
		}
	} );

	api.bind( 'ready', () => {
		addLinks();
	} );

} ( wp.customize, wpex_typography_quick_links_params ) );