<?php
defined( 'ABSPATH' ) || exit;

$bk = $this->get_breakpoint();
$html = '';

if ( $bk ) {
	$bk = '-' . $bk;
	$flex_class = 'wpex-flex wpex-flex-col wpex-flex-grow wpex' . $bk . '-items-center';
} else {
	$flex_class = 'wpex-flex wpex-items-center';
}

// Set flex row class.
if ( $this->has_flex_direction_reverse() ) {
	$flex_row_class = 'wpex' . $bk . '-flex-row-reverse';
} else {
	$flex_row_class = 'wpex' . $bk . '-flex-row';
}

// Begin card output.
$html .= '<div class="wpex-card-inner ' . $flex_class . ' ' . $flex_row_class . ' wpex-gap-15">';

	// Media
	$html .= $this->get_media( array(
		'class' => 'wpex' . $bk . '-w-20 wpex-flex-shrink-0 wpex-self-stretch',
		'thumbnail_args' => array(
			'class' => 'wpex-w-100 wpex-h-100',
			'image_class' => 'wpex-w-100 wpex-h-100 wpex-object-cover',
		),
	) );

	// Details
	$html .= '<div class="wpex-card-details wpex-flex wpex-flex-col wpex-flex-grow';

		if ( $this->has_flex_direction_reverse() ) {
			$html .= ' wpex-items-end';
		}

		$html .= '">';

		// Title
		$html .= $this->get_title( array(
			'class' => 'wpex-heading wpex-text-md wpex-child-inherit-color',
		) );

		// Excerpt
		$html .= $this->get_excerpt( array(
			'class' => 'wpex-my-10',
			'length' => 0
		) );

		// Meta
		$html .= '<div class="wpex-card-meta wpex-flex wpex-flex-wrap wpex-items-center wpex-gap-5 wpex-mt-5">';

			// Date
			$html .= $this->get_date( array(
				'type' => 'published',
			) );

			// Terms
			$primary_term = $this->get_primary_term( array(
				'term_class' => 'wpex-no-underline wpex-hover-underline wpex-text-current wpex-hover-text-1',
				'has_term_background_color' => false,
			) );

			if ( $primary_term  ) {
				$html .= '<span>&ndash;</span>';
				$html .= $primary_term;
			}

		$html .= '</div>';

	$html .= '</div>';

$html .= '</div>';

return $html;