<?php
namespace TotalTheme;

defined( 'ABSPATH' ) || exit;

/**
 * Site Color Schemes.
 *
 * @package TotalTheme
 * @version 5.4
 */
final class Color_Scheme {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of our class.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}
		return static::$instance;
	}

	/**
	 * Construct.
	 */
	public function __construct() {
		add_filter( 'wpex_html_class', __CLASS__ . '::add_html_class' );
		add_filter( 'wp_enqueue_scripts', __CLASS__ . '::wp_enqueue_color_scheme_css' );
	}

	/**
	 * Return available color schemes.
	 */
	public static function get_color_schemes() {
		$color_schemes = array(
		//	'dark' => wpex_asset_url( 'css/color-scheme/dark.css' ),
		);

		/**
		 * Filters the list of available color schemes.
		 *
		 * @array $color_schemes
		 */
		$color_schemes = (array) apply_filters( 'wpex_color_schemes', $color_schemes );

		return $color_schemes;
	}

	/**
	 * Return current color scheme.
	 */
	public static function get_active_color_scheme() {
		$active_scheme = '';

		/**
		 * Filters the current theme color scheme.
		 *
		 * @param string $color_scheme
		 */
		$active_scheme = (string) apply_filters( 'wpex_active_color_scheme', $active_scheme );

		return $active_scheme;
	}

	/**
	 * Loads custom color scheme CSS.
	 */
	public static function wp_enqueue_color_scheme_css() {
		$color_schemes = self::get_color_schemes();

		if ( ! $color_schemes ) {
			return;
		}

		$active_scheme = self::get_active_color_scheme();

		if ( ! $active_scheme ) {
			return;
		}

		$script = $color_schemes[$active_scheme] ?? '';

		if ( $script ) {
			wp_enqueue_style(
				'wpex-color-scheme-' . $active_scheme,
				$color_schemes[$active_scheme],
				array(),
				WPEX_THEME_VERSION
			);
		}

	}

	/**
	 * Add HTML class.
	 */
	public static function add_html_class( $classes ) {
		$classes[] = 'wpex-color-scheme-default'; // dynamic class to use with color scheme switcher.

		if ( self::get_color_schemes() ) {
			$color_scheme = self::get_active_color_scheme();
			if ( $color_scheme ) {
				$classes[] = 'wpex-color-scheme-' . $color_scheme;
			}
		}

		return $classes;
	}

}