<?php
namespace TotalTheme;

defined( 'ABSPATH' ) || exit;

/**
 * Conditional Logic.
 *
 * @package TotalTheme
 * @version 5.4.2
 */
final class Conditional_Logic {

	/**
	 * Result.
	 *
	 * @var bool $result The result of the conditional check.
	 */
	public $result = false;

	/**
	 * Constructor.
	 *
	 * @since 5.3
	 */
	public function __construct( $conditions ) {
		if ( is_string( $conditions ) ) {
			$conditions = str_replace( ' ', '', $conditions );
			parse_str( $conditions, $conditions );
		}

		if ( ! is_array( $conditions ) ) {
			return;
		}

		foreach ( $conditions as $condition => $check ) {

			if ( $this->result ) {
				return; // once the logic has returnd true there is no need to check anymore.
			}

			if ( $this->is_callback_whitelisted( $condition ) && is_callable( $condition ) ) {
				if ( $check ) {
					$this->result = (bool) call_user_func( $condition, $this->string_to_array( $check ) );
				} else {
					$this->result = (bool) call_user_func( $condition );
				}
			}

		}
	}

	/**
	 * Whitelisted callbacks.
	 *
	 * @since 5.4.2
	 */
	private function get_callback_whitelist() {
		$whitelist = array(
			// User
			'is_user_logged_in',
			'is_super_admin',

			// Core
			'is_main_site',

			// Loop
			'is_main_query',
			'is_paged',
			'not_paged',
			'in_the_loop',

			// Posts
			'is_page',
			'is_page_template',
			'is_singular',
			'is_single',
			'is_attachment',
			'is_sticky',
			'has_term',
			'has_tag',
			'has_post_thumbnail',

			// archives
			'is_tax',
			'is_search',
			'is_tag',
			'is_category',
			'is_archive',
			'is_post_type_archive',
			'is_author',
			'is_date',
			'is_year',
			'is_month',
			'is_day',
			'is_time',
			'is_new_day',
			'is_404',

			// Homepage
			'is_home',
			'is_front_page',

			// WooCommerce
			'is_shop',
			'is_product_category',
			'is_product_tag',
			'is_woocommerce',
			'is_wc_endpoint_url',
			'wpex_is_woo_shop',
			'wpex_is_woo_tax',
			'wpex_is_woo_single',

			// Tribe Events
			'tribe_is_event',
			'tribe_is_view',
			'tribe_is_list_view',
			'tribe_is_event_category',
			'tribe_is_in_main_loop',
			'tribe_is_day',
			'tribe_is_month',
			'wpex_is_tribe_events',
		);

		/**
		 * Filters the list of whitelisted callback functions for the themes Conditional_Logic class.
		 *
		 * @param array $whitelist
		 */
		$whitelist = (array) apply_filters( 'wpex_conditional_logic_callable_whitelist', $whitelist );

		return $whitelist;
	}

	/**
	 * Is whitelisted.
	 *
	 * @since 5.4.2
	 */
	private function is_callback_whitelisted( $function = '' ) {
		$whitelist = (array) $this->get_callback_whitelist();
		if ( $whitelist && in_array( $function, $whitelist, true ) ) {
			return true;
		}
		return false;
	}

	/**
	 * Converts strings to arrays.
	 *
	 * @since 5.3
	 */
	private function string_to_array( $input ) {
		if ( is_string( $input ) ) {
			$input = explode( ',', trim( wp_strip_all_tags( $input ) ) );
		}
		return $input;
	}

}