<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

/**
 * Customizer SVG Select Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4.5
 */
class SVG_Select extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex_svg_select';

	/**
	 * Render Control Content.
	 */
	public function render_content() {
		$input_id = '_customize-input-' . $this->id;
		$this_val = $this->value();
		$choices  = $this->choices ?? array();

		if ( is_string( $choices ) && is_callable( $choices ) ) {
			$choices = call_user_func( $choices );
		}

		if ( ! is_array( $choices ) ) {
			return;
		}

		?>

		<label class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>

		<div class="wpex-customize-svg-select">

			<select <?php $this->link(); ?>>
				<?php foreach ( $choices as $svg_file => $svg_name ) { ?>
					<option value="<?php echo esc_attr( $svg_file ); ?>" <?php selected( $svg_file, $this_val, true ); ?>><?php echo esc_html( $svg_name ); ?></option>
				<?php } ?>
			</select>

			<div class="wpex-customize-svg-select__preview">
				<span><?php esc_html_e( 'Preview', 'total' ); ?></span>
				<?php foreach ( $choices as $svg_file => $svg_name ) {
					$svg = wpex_get_svg( 'loaders/' . $svg_file, 20 );
					if ( $svg ) {
						$this_val = $this_val ?: 'wordpress';
						$svg_class = 'wpex-customize-svg-select-icon';
						if ( $svg_file === 'wordpress' ) {
							$svg_class .= ' wpex-customize-svg-select-icon--default';
						}
						if ( $svg_file !== $this_val ) {
							$svg_class .= ' wpex-customize-svg-select-icon--hidden';
						}
						echo '<div class="'. esc_attr( $svg_class ) . '" data-wpex-value="' . esc_attr( $svg_file ) . '">' . $svg . '</div>';
					}
				} ?>
			</div>

		</div>

		<?php
	}

}