<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_blog_single_related'] = array(
	'title' => esc_html__( 'Related Posts', 'total' ),
	'panel' => 'wpex_blog',
	'description' => esc_html__( 'The related posts section displays at the bottom of the post content and can be enabled/disabled via the Post Layout Elements setting under the "Single Post" tab.', 'total' ),
	'settings' => array(
		array(
			'id' => 'blog_related_title',
			'transport' => 'postMessage',
			'default' => esc_html__( 'Related Posts', 'total' ),
			'control' => array(
				'label' => esc_html__( 'Related Posts Title', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_related_entry_card_style',
			'control' => array(
				'label' => esc_html__( 'Card Style', 'total' ),
				'type' => 'wpex-card-select',
			),
		),
		array(
			'id' => 'blog_related_count',
			'default' => 3,
			'control' => array(
				'label' => esc_html__( 'Post Count', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_related_taxonomy',
			'default' => 'category',
			'control' => array(
				'label' => esc_html__( 'Related By', 'total' ),
				'type' => 'select',
				'choices' => 'blog_taxonomies',
			),
		),
		array(
			'id' => 'blog_related_order',
			'default' => 'description',
			'control' => array(
				'label' => esc_html__( 'Order', 'total' ),
				'type' => 'select',
				'choices' => array(
					'description' => esc_html__( 'DESC', 'total' ),
					'asc' => esc_html__( 'ASC', 'total' ),
				),
			),
		),
		array(
			'id' => 'blog_related_orderby',
			'default' => 'date',
			'control' => array(
				'label' => esc_html__( 'Order By', 'total' ),
				'type' => 'select',
				'choices' => array(
					'date' => esc_html__( 'Date', 'total' ),
					'title' => esc_html__( 'Title', 'total' ),
					'modified' => esc_html__( 'Modified', 'total' ),
					'author' => esc_html__( 'Author', 'total' ),
					'rand' => esc_html__( 'Random', 'total' ),
					'comment_count' => esc_html__( 'Comment Count', 'total' ),
				),
			),
		),
		array(
			'id' => 'blog_related_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Columns', 'total' ),
				'type' => 'wpex-columns',
			),
		),
		array(
			'id' => 'blog_related_gap',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => 'column_gap',
			),
		),
		array(
			'id' => 'blog_related_overlay',
			'control' => array(
				'label' => esc_html__( 'Image Overlay', 'total' ),
				'type' => 'select',
				'choices' => 'overlay',
			),
		),
		array(
			'id' => 'blog_related_excerpt',
			'default' => 'on',
			'control' => array(
				'label' => esc_html__( 'Excerpts', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_blog_related_card',
			),
		),
		array(
			'id' => 'blog_related_excerpt_length',
			'default' => '15',
			'control' => array(
				'label' => esc_html__( 'Excerpt Length', 'total' ),
				'type' => 'text',
			),
		),
	)
);