<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_loadmore'] = array(
	'title' => esc_html__( 'Load More / Infinite Scroll', 'total' ),
	'panel' => 'wpex_general',
	'settings' => array(
		array(
			'id' => 'loadmore_btn_expanded',
			'default' => true,
			'control' => array(
				'type' => 'wpex_toggle',
				'label' => esc_html__( 'Expanded Load More Button', 'total' ),
				'description' => esc_html__( 'This setting applies to archives only and does not apply to custom elements like the Post Cards.', 'total' ),
			),
		),
		array(
			'id' => 'loadmore_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Load More Text', 'total' ),
				'input_attrs' => array(
					'placeholder' => esc_html__( 'Load More', 'total' ),
				),
				'description' => esc_html__( 'Here you can change the load more text globally but it can always be dynamically altered via a child theme using the "wpex_loadmore_loading_text" filter.', 'total' ),
			),
		),
		array(
			'id' => 'loadmore_svg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_svg_select',
				'label' => esc_html__( 'Loader Icon', 'total' ),
				'choices' => 'TotalTheme\\Pagination\\Load_More::get_loader_svg_options',
			),
		),
		array(
			'id' => 'loadmore_svg_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'allowed_units' => array( 'px' ),
				'label' => esc_html__( 'Loader Size', 'total' ),
				'placeholder' => '20',
			),
		),
		array(
			'id' => 'loadmore_svg_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Loader Color', 'total' ),
				'description' => esc_html__( 'Note: The default WordPress loader is always gray.', 'total' ),
			),
			'inline_css' => array(
				'target' => '.wpex-load-more-wrap .wpex-spinner, .vcex-loadmore .vcex-spinner',
				'alter' => 'color'
			),
		),
	),
);