<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_pagination'] = array(
	'title' => esc_html__( 'Numbered Pagination', 'total' ),
	'panel' => 'wpex_general',
	'settings' => array(
		array(
			'id' => 'pagination_align',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Alignment', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'left' => esc_html__( 'Left', 'total' ),
					'center' => esc_html__( 'Center', 'total' ),
					'right' => esc_html__( 'Right', 'total' ),
				),
			),
		),
		array(
			'id' => 'pagination_arrow',
			'transport' => 'postMessage',
			'default' => 'angle',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Arrow Style', 'total' ),
				'choices' => array(
					'angle' => esc_html__( 'Angle', 'total' ),
					'arrow' => esc_html__( 'Arrow', 'total' ),
					'caret' => esc_html__( 'Caret', 'total' ),
					'chevron' => esc_html__( 'Chevron', 'total' ),
				),
			),
		),
		array(
			'id' => 'pagination_gutter',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Gutter', 'total' ),
				'placeholder' => '-1',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-gutter',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'pagination_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Font Size', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-font-size',
			),
		),
		array(
			'id' => 'pagination_item_dims',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Item Dimensions', 'total' ),
				'description' => esc_html__( 'Will apply a min-height and min-width to each pagination item. Useful for creating perfect squares or circles.', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array( '--wpex-pagination-link-min-height', '--wpex-pagination-link-min-width' ),
			),
		),
		array(
			'id' => 'pagination_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'label' => esc_html__( 'Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-link-padding',
			),
		),
		array(
			'id' => 'pagination_border_radius',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Border Radius', 'total' ),
				'placeholder' => '3',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-border-radius',
			),
		),
		array(
			'id' => 'pagination_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', 'em', 'rem', 'var', 'func' ),
				'label' => esc_html__( 'Border Width', 'total' ),
				'placeholder' => '1',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-border-width',
			),
		),
		array(
			'id' => 'pagination_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-border-color',
			),
		),
		array(
			'id' => 'pagination_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-link-color',
			),
		),
		array(
			'id' => 'pagination_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-hover-pagination-link-color',
					'--wpex-active-pagination-link-color',
				),
			),
		),
		array(
			'id' => 'pagination_hover_active',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color: Active', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-active-pagination-link-color',
			),
		),
		array(
			'id' => 'pagination_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-pagination-link-bg',
			),
		),
		array(
			'id' => 'pagination_hover_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-hover-pagination-link-bg',
					'--wpex-active-pagination-link-bg',
				),
			),
		),
		array(
			'id' => 'pagination_active_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background: Active', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-active-pagination-link-bg',
			),
		),
	),
);