<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_blockquote'] = array(
	'title' => esc_html__( 'Blockquote', 'total' ),
	'panel' => 'wpex_global_styles',
	'settings' => array(
		array(
			'id' => 'blockquote_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => 'blockquote',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'blockquote_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => 'blockquote',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blockquote_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'label' => esc_html__( 'Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => 'blockquote',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'blockquote_border_width',
			'control' => array(
				'label' => esc_html__( 'Side Border Width', 'total' ),
				'description' => esc_html__( 'When choosing a side border width the blockquote design will be changed from a quote style to a left border design.', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'1px' => '1px',
					'2px' => '2px',
					'3px' => '3px',
					'4px' => '4px',
					'5px' => '5px',
				),
			),
		),
		array(
			'id' => 'blockquote_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => 'blockquote',
				'alter' => 'border-color',
			),
		),
	),
);