<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_menu_search'] = array(
	'title' => esc_html__( 'Menu Search', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'menu_search_style',
			'default' => 'drop_down',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'disabled' => esc_html__( 'Disabled','total' ),
					'drop_down' => esc_html__( 'Drop Down','total' ),
					'overlay' => esc_html__( 'Site Overlay','total' ),
					'header_replace' => esc_html__( 'Header Replace','total' )
				),
				'description' => esc_html__( 'The vertical header may not support all styles.', 'total' ),
			),
		),
		array(
			'id' => 'menu_search_placeholder',
			'control' => array(
				'label' => esc_html__( 'Placeholder Text', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'search_dropdown_top_border',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Drop Down Top Border', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#searchform-dropdown',
				'alter' => '--wpex-dropmenu-colored-top-border-color',
			),
		),
		array(
			'id' => 'search_overlay_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Overlay Background', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#wpex-searchform-overlay',
				'alter' => 'background-color',
			),
		),
	)
);