<?php
namespace TotalTheme\Filters;

defined( 'ABSPATH' ) || exit;

/**
 * Hooks into "the_author_posts_link".
 *
 * @package TotalTheme
 * @subpackage Filters
 * @version 5.4
 */
final class The_Authors_Post_Link {

	/**
	 * Callback method.
	 */
	public static function callback( $link ) {
		if ( $schema = wpex_get_schema_markup( 'author_link' ) ) {
			$link = str_replace( 'rel="author"', 'rel="author"' . $schema, $link );
		}

		return $link;
	}

}