<?php
use TotalTheme\Header\Core as Header;

defined( 'ABSPATH' ) || exit;

/**
 * Check if footer is enabled.
 *
 * @since 4.0
 */
function wpex_has_footer() {
	$check = true;

	// Disabled on landing page.
	if ( is_page_template( 'templates/landing-page.php' ) ) {
		$check = false;
	}

	// Get current post id.
	$post_id = wpex_get_current_post_id();

	// Check page settings.
	if ( $post_id && $meta = get_post_meta( $post_id, 'wpex_disable_footer', true ) ) {
		if ( 'on' === $meta ) {
			$check = false;
		} elseif ( 'enable' === $meta ) {
			$check = true;
		}
	}

	/**
	 * Filters whether the site has a footer or not.
	 *
	 * @param bool $check
	 * @todo rename filter to wpex_has_footer
	 */
	$check = apply_filters( 'wpex_display_footer', $check );

	return $check;
}

/**
 * Check if footer has widgets.
 *
 * @since 4.0
 */
function wpex_footer_has_widgets() {
	if ( wpex_has_custom_footer() || ! empty( $_GET[ 'wpex_inline_footer_template_editor' ] ) ) {
		$check = get_theme_mod( 'footer_builder_footer_widgets', false ); //@todo make the option same value as Customizer?
	} else {
		$check = get_theme_mod( 'footer_widgets', true );
	}

	$post_id = wpex_get_current_post_id();

	if ( $post_id && $meta = get_post_meta( $post_id, 'wpex_disable_footer_widgets', true ) ) {
		if ( 'on' === $meta ) {
			$check = false;
		} elseif ( 'enable' === $meta ) {
			$check = true;
		}
	}

	/**
	 * Filters whether the footer has widgets.
	 *
	 * @paral bool $check
	 */
	$check = (bool) apply_filters( 'wpex_display_footer_widgets', $check );

	return $check;
}

/**
 * Returns footer class.
 *
 * @since 4.9.8
 * @todo update to return full class="" html.
 */
function wpex_footer_class() {
	$class = array(
		'site-footer',
	);

	if ( get_theme_mod( 'footer_dark_surface', true ) ) {
		$class[] = 'wpex-surface-dark';
	}

	if ( get_theme_mod( 'footer_bg_img' ) && $bg_style = get_theme_mod( 'footer_bg_img_style' ) ) {
		$class[] = 'bg-' . sanitize_html_class( $bg_style );
	}

	/**
	 * Filters the footer element class.
	 *
	 * @param array $class
	 */
	$class = (array) apply_filters( 'wpex_footer_class', $class );

	return implode( ' ', $class );
}

/**
 * Returns footer widgets class.
 *
 * @since 4.9.8
 */
function wpex_footer_widgets_class() {
	$columns = (int) get_theme_mod( 'footer_widgets_columns', 4 );
	$gap     = get_theme_mod( 'footer_widgets_gap', '30' );

	$class = array(
		'wpex-row',
		'wpex-clr',
	);

	if ( 1 === $columns ) {
		$class[] = 'single-col-footer'; // legacy class.
	}

	if ( $gap ) {
		$class[] = 'gap-' . sanitize_html_class( $gap );
	}

	/**
	 * Filters the footer widget class.
	 *
	 * @param array $class
	 */
	$class = apply_filters( 'wpex_footer_widgets_class', $class ); // added in 4.9.8

	$class = apply_filters( 'wpex_footer_widget_row_classes', implode( ' ', $class ) ); // @todo deprecate filter;

	return $class;
}

/**
 * Check if footer reveal is enabled.
 *
 * @since 4.0
 */
function wpex_has_footer_reveal( $post_id = '' ) {
	if ( ! wpex_has_footer()
		|| 'boxed' === wpex_site_layout()
		|| 'six' === Header::style()
		|| wpex_vc_is_inline()
	) {
		return false;
	}

	// Check customizer setting.
	$check = get_theme_mod( 'footer_reveal', false );

	// Get current post id if not set.
	if ( ! $post_id ) {
		$post_id = wpex_get_current_post_id();
	}

	// Check page settings.
	if ( $post_id && $meta = get_post_meta( $post_id, 'wpex_footer_reveal', true ) ) {
		if ( 'on' === $meta ) {
			$check = true;
		} elseif ( 'off' === $meta ) {
			$check = false;
		}
	}

	/**
	 * Filters whether the footer reveal is enabled.
	 *
	 * @param bool $check
	 */
	$check = (bool) apply_filters( 'wpex_has_footer_reveal', $check );

	return $check;
}