<?php
defined( 'ABSPATH' ) || exit;

/**
 * Outputs the HTML element class attribute.
 *
 * @since 5.4
 */
function wpex_html_class() {
	$classes = array();

	/**
	 * Filters the html element classes.
	 *
	 * @param array $class
	 */
	$classes = (array) apply_filters( 'wpex_html_class', $classes );

	if ( $classes ) {
		echo 'class="' . esc_attr( implode( ' ', $classes ) ) . '"';
	}
}