<?php
defined( 'ABSPATH' ) || exit;

/**
 * Elements that support local scroll.
 *
 * @since 5.0
 * @return bool Return bool or true
 */
function wpex_get_local_scroll_targets() {
	$targets = 'li.local-scroll a, a.local-scroll, .local-scroll-link, .local-scroll-link > a';

    /**
     * Filters the local scroll target elements.
     *
     * @param bool $check
     */
	$targets = apply_filters( 'wpex_local_scroll_targets', $targets );

	return wp_strip_all_tags( $targets );
}

/**
 * Check if local scroll menu highlight is enabled.
 *
 * @since 5.0
 * @return bool Return bool or true
 */
function wpex_has_local_scroll_menu_highlight() {
	$check = wp_validate_boolean( get_theme_mod( 'local_scroll_highlight', true ) );

    /**
     * Check if the local scroll menu item highlight function is enabled.
     *
     * @param bool $check
     */
    $check = (bool) apply_filters( 'wpex_has_local_scroll_menu_highlight', $check );

	return $check;
}

/**
 * Check if local scroll menu highlight is enabled.
 *
 * @since 5.0
 * @return bool Return bool or true
 */
function wpex_has_local_scroll_on_load() {
	$check = wp_validate_boolean( get_theme_mod( 'scroll_to_hash', true ) );

    /**
     * Check if the local scroll on load function is enabled.
     *
     * @param bool $check
     */
     $check = (bool) apply_filters( 'wpex_has_local_scroll_on_load', $check );

	return $check;
}

/**
 * Check if the url hash should update when clicking local scroll links.
 *
 * @since 5.0
 * @return bool Return bool
 */
function wpex_has_local_scroll_hash_update() {
	$check = wp_validate_boolean( get_theme_mod( 'local_scroll_update_hash', false ) );

    /**
     * Check if the local scroll hash update function is enabled.
     *
     * @param bool $check
     */
    $check = (bool) apply_filters( 'wpex_has_local_scroll_hash_update', $check );

	return $check;
}

/**
 * Return local scroll on load timeout.
 *
 * @since 5.0
 * @return int Return integer or 500
 */
function wpex_get_local_scroll_on_load_timeout() {
	$timeout = get_theme_mod( 'scroll_to_hash_timeout' ) ?: 500;

    /**
     * Filters the local scroll on load timeout time.
     *
     * @param int $timeout
     */
	$timeout = apply_filters( 'wpex_local_scroll_on_load_timeout', $timeout );

	return absint( $timeout );
}

/**
 * Return local scroll easing value.
 *
 * @since 5.0
 * @return string Return string or easeInOutExpo
 */
function wpex_get_local_scroll_easing() {

    $easing = null;

    if ( get_theme_mod( 'scroll_to_easing', true ) ) {
	   $easing = 'easeInOutExpo';
    }

    /**
     * Filters the local scroll easing value.
     *
     * @param string $easing
     */
    $easing = apply_filters( 'wpex_local_scroll_easing', $easing );

    return $easing;

}

/**
 * Return local scroll speed.
 *
 * @since 5.0
 * @return int Return integer or 1000
 */
function wpex_get_local_scroll_speed() {
	$speed = get_theme_mod( 'local_scroll_speed' );
	$speed = ( $speed || '0' === $speed ) ? absint( $speed ) : 1000;

    /**
     * Filters the local scroll speed when using easing js.
     *
     * @param bool $check
     */
	$speed = apply_filters( 'wpex_local_scroll_speed', $speed );

	return absint( $speed );
}