<?php
defined( 'ABSPATH' ) || exit;

/*-------------------------------------------------------------------------------*/
/* [ Table of contents ]
/*-------------------------------------------------------------------------------*

	# General
	# Numbered
	# Next/Prev
	# Inifite Scroll
	# Load More

/*-------------------------------------------------------------------------------*/
/* [ General ]
/*-------------------------------------------------------------------------------*/

/**
 * Returns correct loop pagination.
 */
function wpex_loop_pagination( $loop_type = '', $count = '' ) {
	if ( 'blog' === $loop_type ) {

		global $wp_query;

		$query = $wp_query->query;
		$query['posts_per_page'] = $wp_query->query_vars['posts_per_page']; // pass posts_per_page to the query.

		$pagination_args = array(
			'query'    => $query,
			'is_home'  => is_home(),
			'grid'     => '#blog-entries', // @todo update to target the prev element if this var is empty
			'maxPages' => $wp_query->max_num_pages,
			'category' => is_category() ? get_query_var( 'cat' ) : false,
			'count'    => $count ?: wpex_get_loop_counter(),
		);

		if ( is_category() || is_tag() || is_tax() ) {
			$pagination_args['term_id'] = get_queried_object_id(); // added in v5.0
		}

		wpex_blog_pagination( $pagination_args );

	} else {
		wpex_pagination();
	}
}

/**
 * Archive pagination.
 */
if ( ! function_exists( 'wpex_blog_pagination' ) ) {
	function wpex_blog_pagination( $args = array() ) {
		$pagination_style = get_theme_mod( 'blog_pagination_style', 'standard' );

		if ( is_category() ) {
			$cat_meta = wpex_get_category_meta( get_query_var( 'cat' ), 'wpex_term_pagination' );
			if ( $cat_meta ) {
				$pagination_style = $cat_meta;
			}
		}

		switch ( $pagination_style ) {
			case 'infinite_scroll':
			case 'load_more':
				if ( 'infinite_scroll' === $pagination_style  ) {
					$args['infinite_scroll'] = true;
				}
				TotalTheme\Pagination\Load_More::render_button( $args );
				break;
			case 'next_prev':
				wpex_archive_next_prev_links();
				break;
			default:
				wpex_pagination();
				break;
		} // end switch

	}
}

/*-------------------------------------------------------------------------------*/
/* [ Numbered ]
/*-------------------------------------------------------------------------------*/

/**
 * Numbered Pagination for archives.
 */
function wpex_get_pagination() {
	$arrow_icon = sanitize_html_class( get_theme_mod( 'pagination_arrow' ) ?: 'angle' );

	if ( is_rtl() ) {
		$prev_arrow = $arrow_icon . '-right';
		$next_arrow = $arrow_icon . '-left';
	} else {
		$prev_arrow = $arrow_icon . '-left';
		$next_arrow = $arrow_icon . '-right';
	}

	return get_the_posts_pagination( array(
		'type'               => 'list',
		'prev_text'          => wpex_get_theme_icon_html( $prev_arrow ) . '<span class="screen-reader-text">' . esc_html__( 'Previous', 'total' ) . '</span>',
		'next_text'          => wpex_get_theme_icon_html( $next_arrow ) . '<span class="screen-reader-text">' . esc_html__( 'Next', 'total' ) . '</span>',
		'before_page_number' => '<span class="screen-reader-text">' . esc_html__( 'Page', 'total' ) . ' </span>',
	) );
}


/**
 * Numbered Pagination.
 */
if ( ! function_exists( 'wpex_pagination' ) ) {
	function wpex_pagination( $query = '', $echo = true ) {
		$arrow_icon = sanitize_html_class( get_theme_mod( 'pagination_arrow' ) ?: 'angle' );
		$safe_align = ( $align = get_theme_mod( 'pagination_align' ) ) ? ' text' . sanitize_html_class( $align ) : '';

		if ( is_rtl() ) {
			$prev_arrow = $arrow_icon . '-right';
			$next_arrow = $arrow_icon . '-left';
		} else {
			$prev_arrow = $arrow_icon . '-left';
			$next_arrow = $arrow_icon . '-right';
		}

		// Get global $query.
		if ( ! $query ) {
			global $wp_query;
			$query = $wp_query;
		}

		// Set vars.
		$total = $query->max_num_pages;
		$big   = 999999999;

		// Display pagination.
		if ( $total > 1 ) {

			// Get current page.
			if ( $current_page = get_query_var( 'paged' ) ) {
				$current_page = $current_page;
			} elseif ( $current_page = get_query_var( 'page' ) ) {
				$current_page = $current_page;
			} else {
				$current_page = 1;
			}

			// Get permalink structure.
			if ( get_option( 'permalink_structure' ) ) {
				if ( is_page() ) {
					$format = 'page/%#%/';
				} else {
					$format = '/%#%/';
				}
			} else {
				$format = '&paged=%#%';
			}

			$args = array(
				'base'               => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
				'format'             => $format,
				'current'            => max( 1, $current_page ),
				'total'              => $total,
				'mid_size'           => 3,
				'type'               => 'list',
				'prev_text'          => wpex_get_theme_icon_html( $prev_arrow ) . '<span class="screen-reader-text">' . esc_html__( 'Previous', 'total' ) . '</span>',
				'next_text'          => wpex_get_theme_icon_html( $next_arrow ) . '<span class="screen-reader-text">' . esc_html__( 'Next', 'total' ) . '</span>',
				'before_page_number' => '<span class="screen-reader-text">' . esc_html__( 'Page', 'total' ) . ' </span>',
			);

			/**
			 * Filters the standard pagination args.
			 *
			 * @param array $args
			 */
			$args = apply_filters( 'wpex_pagination_args', $args );

			if ( $echo ) {
				echo '<div class="wpex-pagination wpex-clear wpex-mt-30 wpex-clr' . $safe_align . '">' . paginate_links( $args ) . '</div>';
			} else {
				return '<div class="wpex-pagination wpex-clear wpex-mt-30 wpex-clr' . $safe_align . '">' . paginate_links( $args ) . '</div>';
			}

		}

	}
}

/*-------------------------------------------------------------------------------*/
/* [ Next/Prev ]
/*-------------------------------------------------------------------------------*/

/**
 * Echo Next/Prev Pagination.
 */
function wpex_archive_next_prev_links( $query = '' ) {
	echo wpex_get_archive_next_prev_links( $query );
}

/**
 * Return Next/Prev Pagination.
 */
function wpex_get_archive_next_prev_links( $query = '' ) {
	if ( ! $query ) {
		global $wp_query;
		$query = $wp_query;
	}

	if ( $query->max_num_pages > 1 ) {
		$output = '<div class="page-jump wpex-clr">';
			$output .= '<div class="alignleft newer-posts">';
				$output .= get_previous_posts_link( '&larr; ' . esc_html__( 'Newer Posts', 'total' ) );
			$output .= '</div>';
			$output .= '<div class="alignright older-posts">';
				$output .= get_next_posts_link( esc_html__( 'Older Posts', 'total' ) . ' &rarr;' );
			$output .= '</div>';
		$output .= '</div>';
		return $output;
	}
}