<?php
defined( 'ABSPATH' ) || exit;

/**
 * Returns array of theme icons.
 */
function wpex_ticons_list( $return = 'all', $default = 'none' ) {
	switch ( $return ) {
		case 'up_arrows':
			$icons = array(
				'chevron-up' => 'chevron-up',
				'caret-up' => 'caret-up',
				'angle-up' =>'angle-up',
				'angle-double-up' => 'angle-double-up',
				'long-arrow-up' => 'long-arrow-up',
				'arrow-circle-o-up' => 'arrow-circle-o-up',
				'arrow-up' => 'arrow-up',
				'caret-square-o-up' => 'caret-square-o-up',
				'level-up' => 'level-up',
				'sort-up' => 'sort-up',
				'toggle-up' => 'toggle-up',
			);
			break;
		case 'all':
		default:
			$icons = array( '500px'=>'500px','address-book'=>'address-book','address-book-o'=>'address-book-o','address-card'=>'address-card','address-card-o'=>'address-card-o','adjust'=>'adjust','adn'=>'adn','align-center'=>'align-center','align-justify'=>'align-justify','align-left'=>'align-left','align-right'=>'align-right','amazon'=>'amazon','ambulance'=>'ambulance','american-sign-language-interpreting'=>'american-sign-language-interpreting','anchor'=>'anchor','android'=>'android','angellist'=>'angellist','angle-double-down'=>'angle-double-down','angle-double-left'=>'angle-double-left','angle-double-right'=>'angle-double-right','angle-double-up'=>'angle-double-up','angle-down'=>'angle-down','angle-left'=>'angle-left','angle-right'=>'angle-right','angle-up'=>'angle-up','apple'=>'apple','archive'=>'archive','area-chart'=>'area-chart','arrow-circle-down'=>'arrow-circle-down','arrow-circle-left'=>'arrow-circle-left','arrow-circle-o-down'=>'arrow-circle-o-down','arrow-circle-o-left'=>'arrow-circle-o-left','arrow-circle-o-right'=>'arrow-circle-o-right','arrow-circle-o-up'=>'arrow-circle-o-up','arrow-circle-right'=>'arrow-circle-right','arrow-circle-up'=>'arrow-circle-up','arrow-down'=>'arrow-down','arrow-left'=>'arrow-left','arrow-right'=>'arrow-right','arrow-up'=>'arrow-up','arrows'=>'arrows','arrows-alt'=>'arrows-alt','arrows-h'=>'arrows-h','arrows-v'=>'arrows-v','assistive-listening-systems'=>'assistive-listening-systems','asterisk'=>'asterisk','at'=>'at','audio-description'=>'audio-description','backward'=>'backward','balance-scale'=>'balance-scale','ban'=>'ban','bandcamp'=>'bandcamp','bar-chart'=>'bar-chart','barcode'=>'barcode','bars'=>'bars','bath'=>'bath','battery-0'=>'battery-0','battery-1'=>'battery-1','battery-empty'=>'battery-empty','battery-full'=>'battery-full','battery-half'=>'battery-half','battery-quarter'=>'battery-quarter','battery-three-quarters'=>'battery-three-quarters','bed'=>'bed','beer'=>'beer','behance'=>'behance','behance-square'=>'behance-square','bell'=>'bell','bell-o'=>'bell-o','bell-slash'=>'bell-slash','bell-slash-o'=>'bell-slash-o','bicycle'=>'bicycle','binoculars'=>'binoculars','birthday-cake'=>'birthday-cake','bitbucket'=>'bitbucket','bitbucket-square'=>'bitbucket-square','black-tie'=>'black-tie','blind'=>'blind','bluetooth'=>'bluetooth','bluetooth-b'=>'bluetooth-b','bold'=>'bold','bolt'=>'bolt','bomb'=>'bomb','book'=>'book','bookmark'=>'bookmark','bookmark-o'=>'bookmark-o','braille'=>'braille','briefcase'=>'briefcase','btc'=>'btc','bug'=>'bug','building'=>'building','building-o'=>'building-o','bullhorn'=>'bullhorn','bullseye'=>'bullseye','bus'=>'bus','buysellads'=>'buysellads','calculator'=>'calculator','calendar'=>'calendar','calendar-check-o'=>'calendar-check-o','calendar-minus-o'=>'calendar-minus-o','calendar-o'=>'calendar-o','calendar-plus-o'=>'calendar-plus-o','calendar-times-o'=>'calendar-times-o','camera'=>'camera','camera-retro'=>'camera-retro','car'=>'car','caret-down'=>'caret-down','caret-left'=>'caret-left','caret-right'=>'caret-right','caret-square-o-down'=>'caret-square-o-down','caret-square-o-left'=>'caret-square-o-left','caret-square-o-right'=>'caret-square-o-right','caret-square-o-up'=>'caret-square-o-up','caret-up'=>'caret-up','cart-arrow-down'=>'cart-arrow-down','cart-plus'=>'cart-plus','cc'=>'cc','cc-amex'=>'cc-amex','cc-diners-club'=>'cc-diners-club','cc-discover'=>'cc-discover','cc-jcb'=>'cc-jcb','cc-mastercard'=>'cc-mastercard','cc-paypal'=>'cc-paypal','cc-stripe'=>'cc-stripe','cc-visa'=>'cc-visa','certificate'=>'certificate','chain-broken'=>'chain-broken','check'=>'check','check-circle'=>'check-circle','check-circle-o'=>'check-circle-o','check-square'=>'check-square','check-square-o'=>'check-square-o','chevron-circle-down'=>'chevron-circle-down','chevron-circle-left'=>'chevron-circle-left','chevron-circle-right'=>'chevron-circle-right','chevron-circle-up'=>'chevron-circle-up','chevron-down'=>'chevron-down','chevron-left'=>'chevron-left','chevron-right'=>'chevron-right','chevron-up'=>'chevron-up','child'=>'child','chrome'=>'chrome','circle'=>'circle','circle-o'=>'circle-o','circle-o-notch'=>'circle-o-notch','circle-thin'=>'circle-thin','clipboard'=>'clipboard','clock-o'=>'clock-o','clone'=>'clone','cloud'=>'cloud','cloud-download'=>'cloud-download','cloud-upload'=>'cloud-upload','code'=>'code','code-fork'=>'code-fork','codepen'=>'codepen','codiepie'=>'codiepie','coffee'=>'coffee','cog'=>'cog','cogs'=>'cogs','columns'=>'columns','comment'=>'comment','comment-o'=>'comment-o','commenting'=>'commenting','commenting-o'=>'commenting-o','comments'=>'comments','comments-o'=>'comments-o','compass'=>'compass','compress'=>'compress','connectdevelop'=>'connectdevelop','contao'=>'contao','copyright'=>'copyright','creative-commons'=>'creative-commons','credit-card'=>'credit-card','credit-card-alt'=>'credit-card-alt','crop'=>'crop','crosshairs'=>'crosshairs','css3'=>'css3','cube'=>'cube','cubes'=>'cubes','cutlery'=>'cutlery','dashcube'=>'dashcube','database'=>'database','deaf'=>'deaf','delicious'=>'delicious','desktop'=>'desktop','deviantart'=>'deviantart','diamond'=>'diamond','digg'=>'digg','discord'=>'discord','dot-circle-o'=>'dot-circle-o','download'=>'download','dribbble'=>'dribbble','dropbox'=>'dropbox','drupal'=>'drupal','edge'=>'edge','eercast'=>'eercast','eject'=>'eject','ellipsis-h'=>'ellipsis-h','ellipsis-v'=>'ellipsis-v','empire'=>'empire','envelope'=>'envelope','envelope-o'=>'envelope-o','envelope-open'=>'envelope-open','envelope-open-o'=>'envelope-open-o','envelope-square'=>'envelope-square','envira'=>'envira','eraser'=>'eraser','etsy'=>'etsy','eur'=>'eur','exchange'=>'exchange','exclamation'=>'exclamation','exclamation-circle'=>'exclamation-circle','exclamation-triangle'=>'exclamation-triangle','expand'=>'expand','expeditedssl'=>'expeditedssl','external-link'=>'external-link','external-link-square'=>'external-link-square','eye'=>'eye','eye-slash'=>'eye-slash','eyedropper'=>'eyedropper','facebook'=>'facebook','facebook-official'=>'facebook-official','facebook-square'=>'facebook-square','fast-backward'=>'fast-backward','fast-forward'=>'fast-forward','fax'=>'fax','female'=>'female','fighter-jet'=>'fighter-jet','file'=>'file','file-archive-o'=>'file-archive-o','file-audio-o'=>'file-audio-o','file-code-o'=>'file-code-o','file-excel-o'=>'file-excel-o','file-image-o'=>'file-image-o','file-movie-o'=>'file-movie-o','file-o'=>'file-o','file-pdf-o'=>'file-pdf-o','file-powerpoint-o'=>'file-powerpoint-o','file-text'=>'file-text','file-text-o'=>'file-text-o','file-video-o'=>'file-video-o','file-word-o'=>'file-word-o','files-o'=>'files-o','film'=>'film','filter'=>'filter','fire'=>'fire','fire-extinguisher'=>'fire-extinguisher','firefox'=>'firefox','first-order'=>'first-order','flag'=>'flag','flag-checkered'=>'flag-checkered','flag-o'=>'flag-o','flask'=>'flask','flickr'=>'flickr','floppy-o'=>'floppy-o','folder'=>'folder','folder-o'=>'folder-o','folder-open'=>'folder-open','folder-open-o'=>'folder-open-o','font'=>'font','font-awesome'=>'font-awesome','fonticons'=>'fonticons','fort-awesome'=>'fort-awesome','forumbee'=>'forumbee','forward'=>'forward','foursquare'=>'foursquare','free-code-camp'=>'free-code-camp','frown-o'=>'frown-o','futbol-o'=>'futbol-o','gamepad'=>'gamepad','gavel'=>'gavel','gbp'=>'gbp','genderless'=>'genderless','get-pocket'=>'get-pocket','gg'=>'gg','gg-circle'=>'gg-circle','gift'=>'gift','git'=>'git','git-square'=>'git-square','github'=>'github','github-alt'=>'github-alt','github-square'=>'github-square','gitlab'=>'gitlab','glass'=>'glass','glide'=>'glide','glide-g'=>'glide-g','globe'=>'globe','google'=>'google','google-wallet'=>'google-wallet','graduation-cap'=>'graduation-cap','gratipay'=>'gratipay','grav'=>'grav','h-square'=>'h-square','hacker-news'=>'hacker-news','hand-grab-o'=>'hand-grab-o','hand-lizard-o'=>'hand-lizard-o','hand-o-down'=>'hand-o-down','hand-o-left'=>'hand-o-left','hand-o-right'=>'hand-o-right','hand-o-up'=>'hand-o-up','hand-paper-o'=>'hand-paper-o','hand-peace-o'=>'hand-peace-o','hand-pointer-o'=>'hand-pointer-o','hand-rock-o'=>'hand-rock-o','hand-scissors-o'=>'hand-scissors-o','hand-spock-o'=>'hand-spock-o','hand-stop-o'=>'hand-stop-o','handshake-o'=>'handshake-o','hashtag'=>'hashtag','hdd-o'=>'hdd-o','header'=>'header','headphones'=>'headphones','heart'=>'heart','heart-o'=>'heart-o','heartbeat'=>'heartbeat','history'=>'history','home'=>'home','hospital-o'=>'hospital-o','hotel'=>'hotel','hourglass'=>'hourglass','hourglass-1'=>'hourglass-1','hourglass-2'=>'hourglass-2','hourglass-3'=>'hourglass-3','hourglass-end'=>'hourglass-end','hourglass-half'=>'hourglass-half','hourglass-o'=>'hourglass-o','hourglass-start'=>'hourglass-start','houzz'=>'houzz','html5'=>'html5','i-cursor'=>'i-cursor','id-badge'=>'id-badge','id-card'=>'id-card','id-card-o'=>'id-card-o','ils'=>'ils','imdb'=>'imdb','inbox'=>'inbox','indent'=>'indent','industry'=>'industry','info'=>'info','info-circle'=>'info-circle','inr'=>'inr','instagram'=>'instagram','internet-explorer'=>'internet-explorer','intersex'=>'intersex','ioxhost'=>'ioxhost','italic'=>'italic','joomla'=>'joomla','jpy'=>'jpy','jsfiddle'=>'jsfiddle','key'=>'key','keyboard-o'=>'keyboard-o','krw'=>'krw','language'=>'language','laptop'=>'laptop','lastfm'=>'lastfm','lastfm-square'=>'lastfm-square','leaf'=>'leaf','leanpub'=>'leanpub','lemon-o'=>'lemon-o','level-down'=>'level-down','level-up'=>'level-up','life-ring'=>'life-ring','lightbulb-o'=>'lightbulb-o','line-chart'=>'line-chart','link'=>'link','linkedin'=>'linkedin','linkedin-square'=>'linkedin-square','linode'=>'linode','linux'=>'linux','list'=>'list','list-alt'=>'list-alt','list-ol'=>'list-ol','list-ul'=>'list-ul','location-arrow'=>'location-arrow','lock'=>'lock','long-arrow-down'=>'long-arrow-down','long-arrow-left'=>'long-arrow-left','long-arrow-right'=>'long-arrow-right','long-arrow-up'=>'long-arrow-up','low-vision'=>'low-vision','magic'=>'magic','magnet'=>'magnet','male'=>'male','map'=>'map','map-marker'=>'map-marker','map-o'=>'map-o','map-pin'=>'map-pin','map-signs'=>'map-signs','mars'=>'mars','mars-double'=>'mars-double','mars-stroke'=>'mars-stroke','mars-stroke-h'=>'mars-stroke-h','mars-stroke-v'=>'mars-stroke-v','maxcdn'=>'maxcdn','meanpath'=>'meanpath','medium'=>'medium','medkit'=>'medkit','meetup'=>'meetup','meh-o'=>'meh-o','mercury'=>'mercury','microchip'=>'microchip','microphone'=>'microphone','microphone-slash'=>'microphone-slash','minus'=>'minus','minus-circle'=>'minus-circle','minus-square'=>'minus-square','minus-square-o'=>'minus-square-o','mixcloud'=>'mixcloud','mobile'=>'mobile','modx'=>'modx','money'=>'money','moon-o'=>'moon-o','motorcycle'=>'motorcycle','mouse-pointer'=>'mouse-pointer','music'=>'music','neuter'=>'neuter','newspaper-o'=>'newspaper-o','object-group'=>'object-group','object-ungroup'=>'object-ungroup','odnoklassniki'=>'odnoklassniki','odnoklassniki-square'=>'odnoklassniki-square','opencart'=>'opencart','openid'=>'openid','opera'=>'opera','optin-monster'=>'optin-monster','outdent'=>'outdent','pagelines'=>'pagelines','paint-brush'=>'paint-brush','paper-plane'=>'paper-plane','paper-plane-o'=>'paper-plane-o','paperclip'=>'paperclip','paragraph'=>'paragraph','pause'=>'pause','pause-circle'=>'pause-circle','pause-circle-o'=>'pause-circle-o','paw'=>'paw','paypal'=>'paypal','pencil'=>'pencil','pencil-square'=>'pencil-square','pencil-square-o'=>'pencil-square-o','percent'=>'percent','phone'=>'phone','phone-square'=>'phone-square','picture-o'=>'picture-o','pie-chart'=>'pie-chart','pied-piper'=>'pied-piper','pied-piper-alt'=>'pied-piper-alt','pied-piper-pp'=>'pied-piper-pp','pinterest'=>'pinterest','pinterest-p'=>'pinterest-p','pinterest-square'=>'pinterest-square','plane'=>'plane','play'=>'play','play-circle'=>'play-circle','play-circle-o'=>'play-circle-o','plug'=>'plug','plus'=>'plus','plus-circle'=>'plus-circle','plus-square'=>'plus-square','plus-square-o'=>'plus-square-o','podcast'=>'podcast','power-off'=>'power-off','print'=>'print','product-hunt'=>'product-hunt','puzzle-piece'=>'puzzle-piece','qq'=>'qq','qrcode'=>'qrcode','question'=>'question','question-circle'=>'question-circle','question-circle-o'=>'question-circle-o','quora'=>'quora','quote-left'=>'quote-left','quote-right'=>'quote-right','random'=>'random','ravelry'=>'ravelry','rebel'=>'rebel','recycle'=>'recycle','reddit'=>'reddit','reddit-alien'=>'reddit-alien','reddit-square'=>'reddit-square','refresh'=>'refresh','registered'=>'registered','renren'=>'renren','repeat'=>'repeat','reply'=>'reply','reply-all'=>'reply-all','retweet'=>'retweet','road'=>'road','rocket'=>'rocket','rss'=>'rss','rss-square'=>'rss-square','rub'=>'rub','safari'=>'safari','scissors'=>'scissors','scribd'=>'scribd','search'=>'search','search-minus'=>'search-minus','search-plus'=>'search-plus','sellsy'=>'sellsy','server'=>'server','share'=>'share','share-alt'=>'share-alt','share-alt-square'=>'share-alt-square','share-square'=>'share-square','share-square-o'=>'share-square-o','shield'=>'shield','ship'=>'ship','shirtsinbulk'=>'shirtsinbulk','shopping-bag'=>'shopping-bag','shopping-bag-alt'=>'shopping-bag-alt','shopping-basket'=>'shopping-basket','shopping-basket-alt'=>'shopping-basket-alt','shopping-cart'=>'shopping-cart','shopping-cart-alt'=>'shopping-cart-alt','shower'=>'shower','sign-in'=>'sign-in','sign-language'=>'sign-language','sign-out'=>'sign-out','signal'=>'signal','simplybuilt'=>'simplybuilt','sitemap'=>'sitemap','skyatlas'=>'skyatlas','skype'=>'skype','slack'=>'slack','sliders'=>'sliders','slideshare'=>'slideshare','smile-o'=>'smile-o','snapchat'=>'snapchat','snapchat-ghost'=>'snapchat-ghost','snapchat-square'=>'snapchat-square','snowflake-o'=>'snowflake-o','sort'=>'sort','sort-alpha-asc'=>'sort-alpha-asc','sort-alpha-desc'=>'sort-alpha-desc','sort-amount-asc'=>'sort-amount-asc','sort-amount-desc'=>'sort-amount-desc','sort-asc'=>'sort-asc','sort-desc'=>'sort-desc','sort-numeric-asc'=>'sort-numeric-asc','sort-numeric-desc'=>'sort-numeric-desc','soundcloud'=>'soundcloud','space-shuttle'=>'space-shuttle','spinner'=>'spinner','spoon'=>'spoon','spotify'=>'spotify','square'=>'square','square-o'=>'square-o','stack-exchange'=>'stack-exchange','stack-overflow'=>'stack-overflow','star'=>'star','star-half'=>'star-half','star-half-o'=>'star-half-o','star-o'=>'star-o','steam'=>'steam','steam-square'=>'steam-square','step-backward'=>'step-backward','step-forward'=>'step-forward','stethoscope'=>'stethoscope','sticky-note'=>'sticky-note','sticky-note-o'=>'sticky-note-o','stop'=>'stop','stop-circle'=>'stop-circle','stop-circle-o'=>'stop-circle-o','street-view'=>'street-view','strikethrough'=>'strikethrough','stumbleupon'=>'stumbleupon','stumbleupon-circle'=>'stumbleupon-circle','subscript'=>'subscript','subway'=>'subway','suitcase'=>'suitcase','sun-o'=>'sun-o','superpowers'=>'superpowers','superscript'=>'superscript','table'=>'table','tablet'=>'tablet','tachometer'=>'tachometer','tag'=>'tag','tags'=>'tags','tasks'=>'tasks','taxi'=>'taxi','telegram'=>'telegram','television'=>'television','tencent-weibo'=>'tencent-weibo','terminal'=>'terminal','text-height'=>'text-height','text-width'=>'text-width','th'=>'th','th-large'=>'th-large','th-list'=>'th-list','themeisle'=>'themeisle','thermometer-empty'=>'thermometer-empty','thermometer-full'=>'thermometer-full','thermometer-half'=>'thermometer-half','thermometer-quarter'=>'thermometer-quarter','thermometer-three-quarters'=>'thermometer-three-quarters','thumb-tack'=>'thumb-tack','thumbs-down'=>'thumbs-down','thumbs-o-down'=>'thumbs-o-down','thumbs-o-up'=>'thumbs-o-up','thumbs-up'=>'thumbs-up','ticket'=>'ticket','tiktok'=>'tiktok','times'=>'times','times-circle'=>'times-circle','times-circle-o'=>'times-circle-o','tint'=>'tint','toggle-off'=>'toggle-off','toggle-on'=>'toggle-on','trademark'=>'trademark','train'=>'train','transgender'=>'transgender','transgender-alt'=>'transgender-alt','trash'=>'trash','trash-o'=>'trash-o','tree'=>'tree','trello'=>'trello','tripadvisor'=>'tripadvisor','trophy'=>'trophy','truck'=>'truck','try'=>'try','tty'=>'tty','tumblr'=>'tumblr','tumblr-square'=>'tumblr-square','tv'=>'tv','twitch'=>'twitch','twitter'=>'twitter','twitter-square'=>'twitter-square','umbrella'=>'umbrella','underline'=>'underline','undo'=>'undo','universal-access'=>'universal-access','university'=>'university','unlock'=>'unlock','unlock-alt'=>'unlock-alt','upload'=>'upload','usb'=>'usb','usd'=>'usd','user'=>'user','user-circle'=>'user-circle','user-circle-o'=>'user-circle-o','user-md'=>'user-md','user-o'=>'user-o','user-plus'=>'user-plus','user-secret'=>'user-secret','user-times'=>'user-times','users'=>'users','venus'=>'venus','venus-double'=>'venus-double','venus-mars'=>'venus-mars','viacoin'=>'viacoin','viadeo'=>'viadeo','viadeo-square'=>'viadeo-square','video-camera'=>'video-camera','vimeo'=>'vimeo','vimeo-square'=>'vimeo-square','vk'=>'vk','volume-control-phone'=>'volume-control-phone','volume-down'=>'volume-down','volume-off'=>'volume-off','volume-up'=>'volume-up','weibo'=>'weibo','weixin'=>'weixin','whatsapp'=>'whatsapp','wheelchair'=>'wheelchair','wheelchair-alt'=>'wheelchair-alt','wifi'=>'wifi','wikipedia-w'=>'wikipedia-w','window-close'=>'window-close','window-close-o'=>'window-close-o','window-maximize'=>'window-maximize','window-minimize'=>'window-minimize','window-restore'=>'window-restore','windows'=>'windows','wordpress'=>'wordpress','wpbeginner'=>'wpbeginner','wpexplorer'=>'wpexplorer','wpforms'=>'wpforms','wrench'=>'wrench','xing'=>'xing','xing-square'=>'xing-square','y-combinator'=>'y-combinator','yahoo'=>'yahoo','yc'=>'yc','yelp'=>'yelp','yoast'=>'yoast','youtube'=>'youtube','youtube-play'=>'youtube-play','youtube-square'=>'youtube-square');
			break;
	}

	// Add None to top of array
	$icons = array_merge( array( 'none' ), $icons );

	// Fallback filter
	$icons = apply_filters( 'wpex_get_awesome_icons', $icons ); // @todo deprecate

	/**
	 * Filters the list of theme icons.
	 *
	 * @param array $icons
	 */
	$icons = (array) apply_filters( 'wpex_ticons_list', $icons );

	return $icons;
}

/**
 * Converts font awesome icon class into ticon class.
 */
function wpex_convert_fa_to_ticon( $icon ) {
	return str_replace( 'fa fa-', 'ticon ticon-', $icon );
}