<?php
defined( 'ABSPATH' ) || exit;

/**
 * Check if we should add a responsive wrapper to a given oembed.
 *
 * @since 5.0
 */
function wpex_maybe_add_oembed_responsive_wrap( $url ) {
	if ( ! $url ) {
		return;
	}

	$check = false;

	$hosts = array(
		'youtube.com',
		'youtu.be',
		'youtube-nocookie.com',
		'vimeo.com',
		'blip.tv',
		'money.cnn.com',
		'dailymotion.com',
		'flickr.com',
		'hulu.com',
		'kickstarter.com',
		'soundcloud.com',
		'wistia.net',
	);

	/**
	 * Filters the list of oEmbed hosts to add a responsive wrapper to.
	 *
	 * @param array $hosts
	 */
	$hosts = (array) apply_filters( 'wpex_oembed_responsive_hosts', $hosts );

	if ( $hosts ) {
		foreach ( $hosts as $host ) {
			if ( strpos( $url, $host ) !== false ) {
				$check = true;
				break;
			}
		}
	}

	/**
	 * Filters whether the theme should add a responsive wrapper to your oEmbed or not.
	 *
	 * @param bool $check
	 * @todo rename this filter to wpex_maybe_add_responsive_oembed_wrap
	 */
	$check = (bool) apply_filters( 'wpex_responsive_video_wrap', $check, $url );

	return $check;
}

/**
 * Add responsive classname around oembed.
 */
function wpex_oembed_html( $cache, $url, $attr, $post_ID ) {
	if ( true === wpex_maybe_add_oembed_responsive_wrap( $url ) ) {
		return '<div class="wpex-responsive-media">' . $cache . '</div>';
	} else {
		return $cache;
	}
}
add_filter( 'embed_oembed_html', 'wpex_oembed_html', 99, 4 );

/**
 * Remove frameborder from oembeds.
 *
 * @todo is this still needed?
 */
function wpex_remove_oembed_frameborder( $return, $data, $url ) {
	return str_ireplace( 'frameborder="0"', '', $return );
}
add_filter( 'oembed_dataparse', 'wpex_remove_oembed_frameborder', 10, 3 );