<?php
/**
 * Returns date block for use with meta element.
 *
 * @package TotalTheme
 * @subpackage Partials\Meta\Blocks
 * @version 5.4.2
 */

defined( 'ABSPATH' ) || exit;

$format   = $args['format'] ?? '';
$singular = $args['singular'] ?? true;
$icon     = $args['icon'] ?? 'clock-o';

if ( $singular ) { ?>
    <li class="meta-date"><?php wpex_theme_icon_html( $icon ); ?><time class="updated" datetime="<?php echo esc_attr( the_date( 'Y-m-d', '', '', false ) ); ?>"<?php wpex_schema_markup( 'publish_date' ); ?>><?php echo get_the_date( $format ); ?></time></li>
<?php } else { ?>
    <li class="meta-date"><?php wpex_theme_icon_html( $icon ); ?><time class="updated" datetime="<?php echo esc_attr( the_date( 'Y-m-d', '', '', false ) ); ?>"><?php echo get_the_date( $format ); ?></time></li>
<?php } ?>