<?php
/**
 * Site header search replace.
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 5.4
 */

defined( 'ABSPATH' ) || exit;

$class = array(
    'header-searchform-wrap',
    'wpex-surface-1',
    'wpex-text-3',
    'wpex-absolute',
    'wpex-z-999',
    'wpex-inset-0',
    'wpex-transition-all',
    'wpex-duration-300',
    'wpex-invisible',
    'wpex-opacity-0',
);

$button_hover_class = '';

if ( ! get_theme_mod( 'header_background' ) ) {
    $button_hover_class = ' wpex-hover-text-1';
}

?>

<div id="searchform-header-replace" class="<?php echo esc_attr( implode( ' ', $class ) ); ?>" data-placeholder="<?php echo esc_attr( wpex_get_header_menu_search_form_placeholder() ); ?>" data-disable-autocomplete="true">
	<?php echo wpex_get_header_menu_search_form(); ?>
	<button id="searchform-header-replace-close" class="wpex-unstyled-button wpex-absolute wpex-top-50 wpex-right-0 -wpex-translate-y-50 wpex-transition-colors wpex-user-select-none<?php echo esc_attr( $button_hover_class ); ?>">
        <span class="searchform-header-replace-close__icon" aria-hidden="true">&times;</span>
        <span class="screen-reader-text"><?php esc_html_e( 'Close search', 'total' ); ?></span>
    </button>
</div>