<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * Gutenberg Integration for vcex shortcodes.
 *
 * @package TotalThemeCore
 * @subpackage Vcex
 * @version 1.4.3
 */
final class Gutenberg {

	/**
	 * Gutenberg support for vcex elements.
	 */
	public static function init() {
		if ( ! current_theme_supports( 'gutenberg-editor' ) || ! function_exists( 'register_block_type' ) ) {
			return;
		}

		// Add new Gutenberg category.
		add_filter( 'block_categories_all', __CLASS__ . '::add_block_category' );

		// Register blocks - @todo add filter so people can choose to register blocks or not.
		self::register_blocks();
	}

	/**
	 * Register blocks
	 */
	protected static function register_blocks() {
		$block_objects = array();

		$blocks = array(
			'Button',
			'Alert',
			'Divider_Dots',
			'Contact_Form',
			'Newsletter_Form',
			//'Post_Meta', // there are core issues with the Query loop CSS.
		);

		foreach ( $blocks as $block ){
			if ( shortcode_exists( 'vcex_' . strtolower( $block ) ) ) {
				$block_class = __NAMESPACE__ . '\\Blocks\\' . $block . '\\Block';
				$block_objects[] = new $block_class();
			}
		}

		foreach( $block_objects as $block_obj ) {
			$block_obj->register_block();
		}
	}

	/**
	 * Gutenberg support for vcex elements.
	 */
	public static function add_block_category( $categories ) {
		$category_slugs = wp_list_pluck( $categories, 'slug' );

		if ( ! in_array( 'total', $category_slugs, true ) ) {
		    $categories = array_merge(
		        $categories,
		        array(
		            array(
		                'title' => esc_html__( 'Total', 'total-theme-core' ),
		                'slug'  => 'total',
		                'icon'  => '<svg viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg"><g clip-rule="evenodd" fill="currentColor" fill-rule="evenodd"><path d="m68.3 21.5 33.7-19.5 42.5 24.5 42.4 24.5v39z"/><path d="m17.2 120.7v-20.7-49l60.3 34.9z"/><path d="m186.9 149-42.4 24.5-42.5 24.5-42.4-24.5-15.8-9.2 84.8-49z"/></g></svg>',
		            ),
		        )
		    );
		}

		return $categories;
	}

}