<?php
namespace TotalThemeCore\Vcex;

defined( 'ABSPATH' ) || exit;

/**
 * Vcex Shortcodes Registry.
 *
 * @package Total Theme Core.
 * @subpackage Vcex
 * @version 1.4.3
 */
final class Shortcodes_Registry {

	/**
	 * Registered shortcodes, as `$key => $shortcode_tag` pairs.
	 *
	 * @since 1.4.3
	 */
	private $registered_shortcodes = array();

	/**
	 * Shortcode class path.
	 *
	 * @since 1.4.3
	 */
	private $shortcode_class_path = TTC_PLUGIN_DIR_PATH . 'inc/vcex/shortcodes/';

	/**
	 * Container for the main instance of the class.
	 *
	 * @since 1.4.3
	 */
	private static $instance = null;

	/**
	 * Utility method to retrieve the main instance of the class.
	 *
	 * The instance will be created if it does not exist yet.
	 *
	 * @since 1.4.3
	 */
	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Retrieves list of shortcodes in the queue to be registered.
	 *
	 * @since 1.4.3
	 */
	public static function get_queue() {
		$shortcodes = array(

			// Standard shortcodes.
			'flex_container',
			'grid_container',
			'spacing',
			'divider',
			'heading',
			'button',
			'multi_buttons',
			'toggle_group',
			'toggle',
			'alert',
			'animated_text',
			'wpex_post_cards',
			'blog_grid',
			'blog_carousel',
			'breadcrumbs',
			'bullets',
			'list_item',
			'contact_form',
			'callout',
			'countdown',
			'column_side_border',
			'custom_field',
			'divider_dots',
			'divider_multicolor',
			'form_shortcode',
			'icon_box',
			'feature_box',
			'teaser',
			'icon',
			'image',
			'image_banner',
			'image_before_after',
			'image_carousel',
			'image_flexslider',
			'image_galleryslider',
			'image_grid',
			'image_swap',
			'leader',
			'login_form',
			'milestone',
			'navbar',
			'newsletter_form',
			'portfolio_carousel',
			'portfolio_grid',
			'post_type_grid',
			'post_type_carousel',
			'post_type_slider',
			'post_type_archive',
			'pricing',
			'recent_news',
			'searchbar',
			'shortcode',
			'skillbar',
			'social_links',
			'staff_carousel',
			'staff_grid',
			'staff_social',
			'terms_carousel',
			'terms_grid',
			'testimonials_carousel',
			'testimonials_grid',
			'testimonials_slider',
			'users_grid',

			// Dynamic post modules.
			'page_title',
			'post_comments',
			'post_content',
			'post_excerpt',
			'post_media',
			'post_meta',
			'post_next_prev',
			'post_series',
			'post_terms',
			'author_bio',
			'social_share',

			// Dynamic archive modules.
			'term_description',

			// Custom Grid items.
			'grid_item-post_excerpt',
			'grid_item-post_meta',
			'grid_item-post_terms',
			'grid_item-post_video',

		);

		if ( class_exists( 'WooCommerce' ) ) {
			$shortcodes[] = 'cart_link';
			$shortcodes[] = 'woocommerce_carousel';
			$shortcodes[] = 'woocommerce_loop_carousel';
		}

		$shortcodes = (array) apply_filters( 'vcex_builder_modules', $shortcodes ); // @deprecated 1.2.8

		/**
		 * Filters the vcex shortcodes list.
		 *
		 * @param array $list
		 */
		$shortcodes = (array) apply_filters( 'vcex_shortcodes_list', $shortcodes );

		return $shortcodes;
	}

	/**
	 * Registeres all shortcodes.
	 *
	 * @since 1.4.3
	 */
	public function register_all() {
		$shortcodes = $this->get_queue();
		if ( ! empty( $shortcodes ) ) {
			foreach ( $shortcodes as $key => $val ) {
				$file = '';

				if ( is_array( $val ) ) {
					$condition = $val['condition'] ?? true;

					if ( $condition ) {
						if ( isset( $val['file'] ) ) {
							$file = $val['file'];
						} else {
							$file = $this->shortcode_class_path . $key . '.php';
						}
					}

				} else {
					$file = $this->shortcode_class_path . $val . '.php';
				}

				if ( $file && file_exists( $file ) ) {
					require_once $file;
					$this->registered_shortcodes[] = $val;
				}
			}
		}
	}

	/**
	 * Retrieves all registered shortcodes.
	 *
	 * @since 1.4.3
	 */
	public function get_all_registered() {
		return $this->registered_shortcodes;
	}

}