<?php
/**
 * vcex_post_next_prev shortcode output.
 *
 * @package Total WordPress Theme
 * @subpackage Total Theme Core
 * @version 1.4.5
 */

defined( 'ABSPATH' ) || exit;

// Get and extract shortcode attributes.
$atts = vcex_shortcode_atts( 'vcex_post_next_prev', $atts, 'VCEX_Post_Next_Prev_Shortcode' );

// Define vars.
$prev             = '';
$next             = '';
$icon_left        = '';
$icon_right       = '';
$in_same_term     = ( isset( $atts['in_same_term'] ) && 'true' == $atts['in_same_term'] );
$icon_style       = ( ! empty( $atts['icon_style'] ) && 'none' !== $atts['icon_style'] ) ? $atts['icon_style'] : null;
$same_term_tax    = ! empty( $atts['same_term_tax'] ) ? $atts['same_term_tax'] : 'category';
$link_format      = $atts['link_format'] ?? 'icon';
$has_prev_link    = vcex_validate_boolean( $atts['previous_link'] ?? 'true' );
$has_next_link    = vcex_validate_boolean( $atts['next_link'] ?? 'true' );
$is_order_reverse = vcex_validate_boolean( $atts['reverse_order'] ?? 'false' );

$shortcode_class = array(
	'vcex-post-next-prev',
);

if ( ! empty( $atts['visibility'] ) ) {
	$shortcode_class[] = vcex_parse_visibility_class( $atts['visibility'] );
}

if ( isset( $atts['expand'] ) && 'true' === $atts['expand'] ) {
	$shortcode_class[] = 'wpex-flex';
	$shortcode_class[] = 'wpex-justify-between';
}

if ( ! empty( $atts['align'] ) ) {
	$shortcode_class[] = 'text' . sanitize_html_class( $atts['align'] );
}

switch( $atts['link_format'] ) {
	case 'icon':
		$shortcode_class[] = 'vcex-icon-only';
	break;
	case 'card':
		$shortcode_class[] = 'wpex-grid';
		if ( $has_prev_link && $has_next_link ) {
			$grid_bk = ! empty( $atts['grid_bk'] ) ? $atts['grid_bk'] : 'sm';
			if ( 'none' === $grid_bk ) {
				$shortcode_class[] = 'wpex-grid-cols-2';
			} else {
				$shortcode_class[] = 'wpex-' . sanitize_html_class( $grid_bk ) . '-grid-cols-2';
			}
		}
		$grid_gap = ! empty( $atts['grid_gap'] ) ? $atts['grid_gap'] : '20';
		$shortcode_class[] = 'wpex-gap-' . sanitize_html_class( $grid_gap );
	break;
}

if ( ! empty( $atts['bottom_margin'] ) ) {
	$shortcode_class[] = vcex_sanitize_margin_class( $atts['bottom_margin'], 'wpex-mb-' );
}

if ( ! empty( $atts['max_width'] ) ) {

	switch ( $atts['float'] ) {
		case 'left':
			$shortcode_class[] = 'wpex-mr-auto';
			break;
		case 'right':
			$shortcode_class[] = 'wpex-ml-auto';
			break;
		case 'center':
		default:
			$shortcode_class[] = 'wpex-mx-auto';
			break;
	}

}

if ( ! empty( $atts['el_class'] ) ) {
	$shortcode_class[] = vcex_get_extra_class( $atts['el_class'] );
}

if ( ! empty( $atts['css_animation'] ) ) {
	$shortcode_class[] = vcex_get_css_animation( $atts['css_animation'] );
}

$shortcode_class = vcex_parse_shortcode_classes( $shortcode_class, 'vcex_post_next_prev', $atts );

// Inline CSS
$shortcode_style = vcex_inline_style( array(
	'font_size'          => $atts['font_size'] ?? '',
	'line_height'        => $atts['line_height'] ?? '',
	'animation_delay'    => $atts['animation_delay'] ?? '',
	'animation_duration' => $atts['animation_duration'] ?? '',
	'max_width'          => $atts['max_width'] ?? '',
) );

// Begin output.
$html = '<div class="' . esc_attr( $shortcode_class ) . '"' . $shortcode_style . '>';

	// Set vars for non card style formats.
	if ( 'card' !== $link_format ) {

		// Define icon HTML.
		if ( $icon_style ) {

			// Sanitize icon spacing.
			$icon_margin_escaped = ! empty( $atts['icon_margin'] ) ? absint( $atts['icon_margin'] ) : 10;

			// Define left/right directions for RTL.
			$left_dir = vcex_parse_direction( 'left' );
			$right_dir = vcex_parse_direction( 'right' );

			// Sanitize icon style.
			$icon_style_escaped = sanitize_html_class( $icon_style );

			// Left Icon.
			$icon_left_class = array(
				'ticon',
				'ticon-' . sanitize_html_class( $icon_style ) . '-' . vcex_parse_direction( 'left' ),
			);

			if ( 'icon' !== $link_format ) {
				$icon_left_class[] = 'wpex-mr-' . $icon_margin_escaped;
			}

			$icon_left = '<span class="' . esc_attr( implode( ' ', $icon_left_class ) ) . '"></span>';

			// Right Icon.
			$icon_right_class = array(
				'ticon',
				'ticon-' . sanitize_html_class( $icon_style ) . '-' . vcex_parse_direction( 'right' ),
			);

			if ( 'icon' !== $link_format ) {
				$icon_right_class[] = 'wpex-ml-' . $icon_margin_escaped;
			}

			$icon_right = '<span class="' . esc_attr( implode( ' ', $icon_right_class ) ) . '"></span>';

		}

		// Get button class.
		$button_style = $atts['button_style'] ?? '';
		$button_color = $atts['button_color'] ?? null;
		$button_class = vcex_get_button_classes( $button_style, $button_color );

		if ( ! empty( $atts['line_height'] ) ) {
			$button_class .= ' wpex-inherit-leading';
		}

		if ( 'plain-text' === $button_style && vcex_validate_att_boolean( 'button_no_underline', $atts ) ) {
			$button_class .= ' wpex-no-underline';
		}

		// Get button inline style.
		$button_style_escaped = vcex_inline_style( array(
			'min_width' => $atts['button_min_width'] ?? '',
		) );

	}


	// Display previous link.
	if ( $has_prev_link ) {

		$get_prev = get_previous_post( $in_same_term, '', $same_term_tax );

		if ( $get_prev ) {

			if ( 'card' === $link_format ) {

				if ( function_exists( 'wpex_get_card' ) ) {
					$prev = wpex_get_card( array(
						'style' => $atts['card_style'] ?? null,
						'post_id' => $get_prev->ID,
					) );
				}

			} else {

				switch ( $link_format ) {
					case 'icon':
						$prev_format_escaped = $is_order_reverse ? $icon_right : $icon_left;
						break;
					case 'title':
						$title = get_the_title( $get_prev->ID );
						$prev_format_escaped = $is_order_reverse ? $title . $icon_right : $icon_left . $title;
						break;
					case 'custom':

						$prev_text = esc_html( $atts['previous_link_custom_text'] );

						if ( ! $prev_text ) {
							$prev_text = esc_html__( 'Previous', 'total-theme-core' );
						}

						$prev_format_escaped = $is_order_reverse ? $prev_text . $icon_right : $icon_left . $prev_text;
						break;
					default :
						$prev_format_escaped = '';
						break;
				}

				if ( $prev_format_escaped ) {
					$prev = '<a href="' . esc_url( get_permalink( $get_prev->ID ) ) . '" class="' . esc_attr( $button_class ) . ' wpex-text-center wpex-max-w-100"' . $button_style_escaped . '>' . $prev_format_escaped . '</a>';

					$prev = apply_filters( 'vcex_post_next_prev_link_next_html', $prev, $get_prev, $prev_format_escaped, $atts );
				}

			}

		}

	}

	if ( $has_next_link ) {

		$get_next = get_next_post( $in_same_term, '', $same_term_tax );

		if ( $get_next ) {

			if ( 'card' === $link_format ) {

				if ( function_exists( 'wpex_get_card' ) ) {
					$next = wpex_get_card( array(
						'style' => $atts['card_style'] ?? null,
						'post_id' => $get_next->ID,
					) );
				}

			} else {

				switch ( $link_format ) {

					case 'icon':
						$next_format_escaped = $is_order_reverse ? $icon_left : $icon_right;
						break;
					case 'title':
						$title = get_the_title( $get_next->ID );
						$next_format_escaped = $is_order_reverse ? $icon_left . $title : $title . $icon_right;
						break;
					case 'custom':

						$next_text = esc_html( $atts['next_link_custom_text'] );

						if ( ! $next_text ) {
							$next_text = esc_html__( 'Next', 'total-theme-core' );
						}

						$next_format_escaped = $is_order_reverse ? $icon_left . $next_text : $next_text . $icon_right;
						break;
					default:
						$next_format_escaped = '';
						break;

				}

				if ( $next_format_escaped ) {
					$next = '<a href="' . esc_url( get_permalink( $get_next->ID ) ) . '" class="' . esc_attr( $button_class ) . ' wpex-text-center wpex-max-w-100"' . $button_style_escaped . '>' . $next_format_escaped . '</a>';

					$next = apply_filters( 'vcex_post_next_prev_link_prev_html', $next, $get_next, $next_format_escaped, $atts );
				}

			}

		}

	}

	if ( 'card' === $link_format ) {

		if ( $is_order_reverse ) {
			if ( $has_next_link ) {
				$html .= '<div class="vcex-post-next-prev__next wpex-flex">' . $next .'</div>';
			}
			if ( $has_prev_link ) {
				$html .= '<div class="vcex-post-next-prev__prev wpex-flex">' . $prev .'</div>';
			}
		} else {
			if ( $has_prev_link ) {
				$html .= '<div class="vcex-post-next-prev__prev wpex-flex">' . $prev .'</div>';
			}
			if ( $has_next_link ) {
				$html .= '<div class="vcex-post-next-prev__next wpex-flex">' . $next .'</div>';
			}
		}

	} else {

		// Sanitize col spacing.
		$col_spacing = ! empty( $atts['spacing'] ) ? absint( $atts['spacing'] ) : 5;

		// Col Classes.
		$first_col_class = 'vcex-col wpex-inline-block wpex-mr-' . sanitize_html_class( $col_spacing );
		$second_col_class = 'vcex-col wpex-inline-block wpex-ml-' . sanitize_html_class( $col_spacing );

		if ( $is_order_reverse ) {
			if ( $has_next_link ) {
				$html .= '<div class="vcex-post-next-prev__next ' . esc_attr( $first_col_class ) . '">' . $next .'</div>';
			}
			if ( $has_prev_link ) {
				$html .= '<div class="vcex-post-next-prev__prev ' . esc_attr( $second_col_class ) . '">' . $prev .'</div>';
			}
		} else {
			if ( $has_prev_link ) {
				$html .= '<div class="vcex-post-next-prev__prev ' . esc_attr( $first_col_class ) . '">' . $prev .'</div>';
			}
			if ( $has_next_link ) {
				$html .= '<div class="vcex-post-next-prev__next ' . esc_attr( $second_col_class ) . '">' . $next .'</div>';
			}
		}

	}

$html .= '</div>';

// @codingStandardsIgnoreLine
echo $html;