( function() {

	if ( ! wp || ! wp.customize ) {
		console.log( 'wp or wp.customize objects not found.' );
		return;
	}

	if ( 'undefined' === typeof wpex_control_display ) {
		console.log( 'wpex_control_display not found' );
		return;
	}

	var checkVal = function( currenVal, targetVal, compare ) {
		var check = false;
		if ( _.isArray( targetVal ) ) {
			check = _.contains( targetVal, currenVal );
		} else {
			switch( targetVal ) {
				case 'not_empty':
				case 'true':
					check = currenVal;
				break;
				case 'false':
					if ( '0' === currenVal ) {
						check = true;
					} else {
						check = !currenVal;
					}
				break;
				default:
					check = ( targetVal == currenVal ) ? true : false; // use lose comparison to check for 0 == false
				break;
			}
		}
		return 'not_equal' === compare ? !check : check;
	};

	var checkVisibility = function( args, control ) {
		var targetControl = args.check;
		var targetValue   = args.value;
		var compare       = args.compare || 'equal_to';

		// Handle changes to the targetControl.
		wp.customize( targetControl, function( targetSetting ) {

			// Check's if the targetControl is enabled.
			var isEnabled = function() {
				return checkVal( targetSetting.get(), targetValue, compare );
			};

			// Update state.
			var visibilityCheck = function( control ) {
				var setActiveState = function() {
					var control_id = control.id;
					if ( isEnabled() ) {
						control.activate();
					} else {
						control.deactivate();
					}
					/* Show or hide any dependent controls.
					// This causes issues with certain settings like social_share_alignment
					_.each( wpex_control_display, function( args, control ) {
						if ( args.check === control_id ) {
							var controlDep = document.querySelector( '#customize-control-' + control );
							if ( controlDep ) {
								var compare = args.compare || 'equal_to';
								var check = checkVal( wp.customize( control ).get(), args.value, compare );
								if ( check ) {
									controlDep.style.display = '';
								} else {
									console.log( control );
									controlDep.style.display = 'none';
								}
							}
						}
					} );*/
				};

				// Makes sure the control is validated to prevent the need for PHP active_callback.
				control.active.validate = isEnabled;

				// Set initial active state on Customizer load.
				setActiveState();

				// Update activate state whenever the targetControl is changed.
				targetSetting.bind( setActiveState );
			};

			// Show/Hide the control depending on the targetControl value.
			wp.customize.control( control, visibilityCheck );
		} );

	};

	wp.customize.bind( 'ready', function() {
		_.each( wpex_control_display, function( args, name ) {
			checkVisibility( args, name );
		} );
	} );

}() );