<?php
defined( 'ABSPATH' ) || exit;

$html = '';

// Get card breakpoint.
$bk = $this->get_breakpoint();

if ( $bk ) {
	$bk = '-' . $bk;
	$flex_class = 'wpex-flex wpex-flex-col wpex-flex-grow';
} else {
	$flex_class = 'wpex-flex';
}

// Set flex row class.
if ( $this->has_flex_direction_reverse() ) {
	$flex_row_class = 'wpex' . $bk . '-flex-row-reverse';
} else {
	$flex_row_class = 'wpex' . $bk . '-flex-row';
}

// Begin card output.
$html .= '<div class="wpex-card-inner ' . $flex_class . ' ' . $flex_row_class . ' wpex-surface-1 wpex-border wpex-border-solid wpex-border-main">';

	// Media
	$html .= $this->get_media( array(
		'class' => 'wpex' . $bk . '-w-50 wpex-flex-shrink-0 wpex-self-stretch',
		'thumbnail_args' => array(
			'class' => 'wpex-w-100 wpex-h-100',
			'image_class' => 'wpex-w-100 wpex-h-100 wpex-object-cover',
		),
	) );

	$html .= '<div class="wpex-card-details wpex-flex-grow wpex-p-25 wpex-last-mb-0">';

		// Primary term
		$html .= $this->get_primary_term( array(
			'class' => 'wpex-font-semibold wpex-leading-normal wpex-mb-15',
			'term_class' => 'wpex-inline-block wpex-bg-accent wpex-hover-bg-accent_alt wpex-no-underline wpex-px-10 wpex-py-5 wpex-text-xs',
			'has_term_background_color' => true,
		) );

		// Title
		$html .= $this->get_title( array(
			'class' => 'wpex-heading wpex-text-xl wpex-font-bold wpex-my-15',
			'link_class' => 'wpex-inherit-color-important',
		) );

		// Excerpt
		$html .= $this->get_excerpt( array(
			'class' => 'wpex-text-3 wpex-my-15',
		) );

		// Date
		$html .= $this->get_date( array(
			'type' => 'modified',
			'class' => 'wpex-mt-20',
			'icon' => 'ticon ticon-clock-o wpex-mr-5',
		) );

	$html .= '</div>';

$html .= '</div>';

return $html;