<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_author_box'] = array(
	'title' => esc_html__( 'Author Box', 'total' ),
	'panel' => 'wpex_blog',
	'settings' => array(
		array(
			'id' => 'author_box_heading_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Heading Font Size', 'total' ),
				'type' => 'wpex_length_unit',
			),
			'inline_css' => array(
				'target' => '.author-bio-title',
				'alter' => 'font-size',
				'sanitize' => 'font_size',
			),
		),
		array(
			'id' => 'author_box_heading_tag',
			'transport' => 'postMessage',
			'default' => 'h3',
			'control' => array(
				'label' => esc_html__( 'Heading HTML Tag', 'total' ),
				'type' => 'select',
				'choices' => 'html_tag',
			),
		),
		array(
			'id' => 'author_box_avatar_size',
			'transport' => 'postMessage',
		//	'sanitize_callback' => 'absint', // causes issues with the customizer not saving empty strings.
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Avatar Size', 'total' ),
				'description' => esc_html__( 'Enter 0 to disable the avatar display.', 'total' ),
				'placeholder' => '70',
			),
			'inline_css' => array(
				'target' => '.author-bio-avatar img',
				'alter' => array( 'width', 'height' ),
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'author_box_avatar_border_radius',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Avatar Border Radius', 'total' ),
				'choices' => 'border_radius',
			),
		),
		array(
			'id' => 'author_box_gap',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Gap Between Avatar & Content', 'total' ),
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'5' => '5px',
					'10' => '10px',
					'15' => '15px',
					'20' => '20px',
					'25' => '25px',
					'30' => '30px',
					'35' => '35px',
					'40' => '40px',
					'50' => '50px',
					'60' => '50px',
				),
			),
		),
		array(
			'id' => 'author_box_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '.author-bio',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'author_box_heading_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Heading Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.author-bio-title',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'author_box_description_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Description Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.author-bio',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'author_box_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'total' ),
				'input_attrs' => array(
					'placeholder' => '0px',
				),
			),
			'inline_css' => array(
				'target' => '.author-bio',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'author_box_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'total' ),
				'input_attrs' => array(
					'placeholder' => '20px',
				),
			),
			'inline_css' => array(
				'target' => '.author-bio',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'author_box_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '.author-bio',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'author_box_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'total' ),
				'input_attrs' => array(
					'placeholder' => '1px',
				),
			),
			'inline_css' => array(
				'target' => '.author-bio',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'author_box_social_style',
			'transport' => 'partialRefresh',
			'default' => 'flat-color-round',
			'control' => array(
				'label' => esc_html__( 'Social Style', 'total' ),
				'type' => 'select',
				'choices' => 'social_styles',
			),
		),
		array(
			'id' => 'author_box_social_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Social Font Size', 'total' ),
			),
			'inline_css' => array(
				'target' => '.author-bio-social .wpex-social-btn',
				'alter' => 'font-size',
			),
		),
	)
);