<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_comments'] = array(
	'title' => esc_html__( 'Comments', 'total' ),
	'panel' => 'wpex_blog',
	'settings' => array(
		array(
			'id' => 'comment_form_classic',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Classic Comment Form', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Modifies the default WordPress comment form layout so that the comment box is after the name and email fields.', 'total' ),
			),
		),
		array(
			'id' => 'bypostauthor_highlight',
			'control' => array(
				'label' => esc_html__( 'Comment Author Label', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Displays an "Author" label next to the name for any comment made by the author of the post.', 'total' ),
			),
		),
		array(
			'id' => 'comment_fn_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Author Name Font Size', 'total' ),
				'type' => 'wpex_length_unit',
			),
			'inline_css' => array(
				'target' => '#comments .comment-meta .fn',
				'alter' => 'font-size',
				'sanitize' => 'font_size',
			),
		),
		array(
			'id' => 'comment_avatar_size',
			'control' => array(
				'label' => esc_html__( 'Avatar Size', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'placeholder' => '50',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-comment-avatar-size',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'comment_avatar_border_radius',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Avatar Border Radius', 'total' ),
				'type' => 'select',
				'choices' => 'border_radius',
				'sanitize' => 'px',
			),
			'inline_css' => array(
				'target' => '#comments .comment-author .avatar',
				'alter' => 'border-radius',
				'sanitize' => 'utl_border_radius',
			),
		),
		array(
			'id' => 'comment_avatar_margin',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Avatar Side Margin', 'total' ),
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'placeholder' => '20',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-comment-avatar-margin',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'comment_spacing',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Spacing Between Comments', 'total' ),
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'placeholder' => '20',
				'description' => esc_html__( 'Applies a bottom padding and margin to the comment, so if you set the border width below to 0px you may want to make this value half of what it was.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#comments .comment-body',
				'alter' => array(
					'margin-bottom',
					'padding-bottom',
				),
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'comment_body_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Comment Border Width', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'0px' => '0px',
					'1px' => '1px',
					'2px' => '2px',
					'3px' => '3px',
					'4px' => '4px',
					'5px' => '5px',
				),
			),
			'inline_css' => array(
				'target' => '#comments .comment-body',
				'alter' => 'border-width',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'comment_body_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Comment Border Color', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#comments .comment-body',
				'alter' => 'border-color',
			),
		),
	),
);