<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_fixed'] = array(
	'title' => esc_html__( 'Sticky Header', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'fixed_header_style',
			'transport' => 'refresh',
			'default' => 'standard',
			'sanitize_callback' => 'esc_html',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'disabled' => esc_html__( 'Disabled', 'total' ),
					'standard' => esc_html__( 'Standard', 'total' ),
					'shrink' => esc_html__( 'Shrink', 'total' ),
					'shrink_animated' => esc_html__( 'Animated Shrink', 'total' ),
				),
				'active_callback' => 'wpex_cac_header_supports_fixed_header',
			),
		),
		array(
			'id' => 'fixed_header_mobile',
			'sanitize_callback' => 'esc_html',
			'control' => array(
				'label' => esc_html__( 'Sticky on Mobile', 'total' ),
				'description' => esc_html__( 'If disabled the sticky header will only function on desktops.', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_header_supports_fixed_header',
			),
		),
		array(
			'id' => 'fixed_header_start_position',
			'sanitize_callback' => 'esc_html',
			'control' => array(
				'label' => esc_html__( 'Sticky Start Position', 'total' ),
				'type' => 'text',
				'active_callback' => 'wpex_cac_header_supports_fixed_header',
				'description' => esc_html__( 'By default, the header becomes sticky as soon as you reach the header while scrolling. You can use this field to enter a number (in pixels) to offset the point at which the header becomes sticky (based on the top of the page) or the classname or ID of another element so that the header becomes sticky when it reaches that point (example: #my-custom-div).', 'total' ),
			),
		),
		array(
			'id' => 'fixed_header_shrink_start_height',
			'control' => array(
				'label' => esc_html__( 'Logo Start Height', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'description' => esc_html__( 'Applies a max height to your header logo to provide a smoother animation when shrinking.', 'total' ),
				'active_callback' => 'wpex_cac_logo_start_height',
				'placeholder' => '60',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-header-shrink-start-height',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'fixed_header_shrink_end_height',
			'control' => array(
				'label' => esc_html__( 'Shrunk Height', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'description' => esc_html__( 'Unless you are using one of the "Flex" header styles, the end height will be set to your Shrunk Height value plus 20px for a top and bottom padding of 10px.', 'total' ),
				'active_callback' => 'wpex_cac_has_fixed_header_shrink',
				'placeholder' => '50',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-header-shrink-end-height',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'fixed_header_shrink_end_logo_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Logo Shrunk Font Size', 'total' ),
				'type' => 'wpex_length_unit',
				'active_callback' => 'wpex_cac_has_fixed_header_shrink',
				'description' => esc_html__( 'If you are not using an image logo you can enter a font size for your text logo when the sticky header is shrunk.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-header.sticky-header-shrunk .site-logo-text',
				'alter' => 'font-size',
			),
		),
		// @todo change to % input.
		array(
			'id' => 'fixed_header_opacity',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'number',
				'label' => esc_html__( 'Opacity', 'total' ),
				'active_callback' => 'wpex_cac_has_fixed_header',
				'input_attrs' => array(
					'placeholder' => '1',
					'min'  => 0.1,
					'max'  => 1,
					'step' => 0.1,
				),
			),
			'inline_css' => array(
				'target' => '.wpex-sticky-header-holder.is-sticky #site-header',
				'alter' => 'opacity',
			),
		),
		array(
			'id' => 'fixed_header_logo',
			'sanitize_callback' => 'absint',
			'control' => array(
				'label' => esc_html__( 'Sticky Logo', 'total' ),
				'type' => 'media',
				'mime_type' => 'image',
				'active_callback' => 'wpex_cac_supports_fixed_header_logo',
				'description' => esc_html__( 'If this custom logo is a different size, for best results go to the Logo section and apply a custom height to your logo.', 'total' ),
			),
		),
		array(
			'id' => 'fixed_header_logo_retina',
			'sanitize_callback' => 'absint',
			'control' => array(
				'label' => esc_html__( 'Sticky Logo Retina', 'total' ),
				'type' => 'media',
				'mime_type' => 'image',
				'active_callback' => 'wpex_cac_has_fixed_header_logo',
			),
		),
	)
);