<?php
defined( 'ABSPATH' ) || exit;

// General
$this->sections['wpex_layout_general'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'panel' => 'wpex_layout',
	'settings' => array(
		array(
			'id' => 'container_max_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Max Width', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( '%', 'px', 'vw', 'var', 'func' ),
				'placeholder' => '90',
				'default_unit' => '%',
				'description' => esc_html__( 'Used to prevent the site content from touching the edge of browser screen. It is recommended to use relative unit such as % or vw. Using a px unit will break the fluid layout unless your container width is using a relative unit.', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root,.boxed-main-layout.wpex-responsive #wrap',
				'alter' => '--wpex-container-max-width',
			),
			'control_display' => array(
				'check' => 'responsive',
				'value' => 'true',
			),
		),
		array(
			'id' => 'content_layout',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Content Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
				'description' => esc_html__( 'Select your default content layout for your site. You can always browse to different tabs in the Customizer such as the blog tab to alter your layout specifically for your blog archives and posts.', 'total' ),
			),
		),
		array(
			'id' => 'main_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Site Layout Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','total' ),
					'boxed' => esc_html__( 'Boxed','total' )
				),
			),
		),
		array(
			'id' => 'boxed_dropdshadow',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container Drop Shadow', 'total' ),
				'type' => 'wpex_toggle', // @todo change to choices so we can choose from preset shadows.
			),
			'control_display' => array(
				'check' => 'main_layout_style',
				'value' => 'boxed',
			),
		),
		array(
			'id' => 'boxed_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Outer Margin', 'total' ),
				'input_attrs' => array(
					'placeholder' => '40px 30px',
				),
			),
			'control_display' => array(
				'check' => 'main_layout_style',
				'value' => 'boxed',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-boxed-layout-padding',
			),
		),
		array(
			'id' => 'boxed_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Inner Gutter', 'total' ),
				'placeholder' => '30',
			),
			'control_display' => array(
				'check' => 'main_layout_style',
				'value' => 'boxed',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 768px)',
				'target' => ':root',
				'alter' => '--wpex-boxed-layout-gutter',
				'sanitize' => 'fallback_px',
			),
		),
		array(
			'id' => 'boxed_wrap_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Inner Background', 'total' ),
			),
			'control_display' => array(
				'check' => 'main_layout_style',
				'value' => 'boxed',
			),
			'inline_css' => array(
				'target' => array(
					'.boxed-main-layout #wrap',
					'.boxed-main-layout #site-header-sticky-wrapper.is-sticky #site-header',
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'site_frame_border',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Site Frame Border', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'site_frame_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Site Frame Border Color', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '#wpex-sfb-l,#wpex-sfb-r,#wpex-sfb-t,#wpex-sfb-b',
				'alter' => 'background-color',
			),
			'control_display' => array(
				'check' => 'site_frame_border',
				'value' => 'true',
			),
		),
		array(
			'id' => 'site_frame_border_size',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Site Frame Border Size', 'total' ),
				'type' => 'wpex_pixel',
				'input_attrs' => array(
					'placeholder' => '10',
				),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-site-frame-border-size',
				'sanitize' => 'px',
			),
			'control_display' => array(
				'check' => 'site_frame_border',
				'value' => 'true',
			),
		),
	),
);

// Desktop Widths
$this->sections['wpex_layout_desktop_widths'] = array(
	'title' => esc_html__( 'Desktop Widths', 'total' ),
	'panel' => 'wpex_layout',
	'description' => esc_html__( 'For screens greater than or equal to 960px.', 'total' ),
	'settings' => array(
		array(
			'id' => 'main_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Main Container Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'placeholder' => '980',
			),
			'inline_css' => array(
				'target' => ':root,.boxed-main-layout.wpex-responsive #wrap',
				'alter' => '--wpex-container-width',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content Area Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'default_unit' => '%',
				'placeholder' => '69',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-content-area-width',
				'media_query' => '(min-width: 960px)',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'default_unit' => '%',
				'placeholder' => '26',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-primary-sidebar-width',
				'media_query' => '(min-width: 960px)',
				'sanitize' => 'container_width',
			),
		),
	),
);

// Medium Screen Widths
$this->sections['wpex_layout_medium_widths'] = array(
	'title' => esc_html__( 'Medium Screens Widths', 'total' ),
	'panel' => 'wpex_layout',
	'description' => esc_html__( 'For screens between 960px - 1280px. Such as landscape tablets and small monitors/laptops.', 'total' ),
	'settings' => array(
		array(
			'id' => 'tablet_landscape_main_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Main Container Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'placeholder' => esc_html__( 'inherit from desktop widths', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root,.boxed-main-layout.wpex-responsive #wrap',
				'alter' => '--wpex-container-width',
				'media_query' => '(min-width: 960px) and (max-width: 1280px)',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'tablet_landscape_left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content Area Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'default_unit' => '%',
				'placeholder' => esc_html__( 'inherit from desktop widths', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-content-area-width',
				'media_query' => '(min-width: 960px) and (max-width: 1280px)',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'tablet_landscape_sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'default_unit' => '%',
				'placeholder' => esc_html__( 'inherit from desktop widths', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-primary-sidebar-width',
				'media_query' => '(min-width: 960px) and (max-width: 1280px)',
				'sanitize' => 'container_width',
			),
		),
	),
);

// Tablet Portrait Widths
$this->sections['wpex_layout_tablet_widths'] = array(
	'title' => esc_html__( 'Tablet Widths', 'total' ),
	'panel' => 'wpex_layout',
	'description' => esc_html__( 'For screens between 768px - 959px. Such as portrait tablet.', 'total' ),
	'settings' => array(
		array(
			'id' => 'tablet_main_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Main Container Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'placeholder' => esc_html__( 'inherit from desktop widths', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root,.boxed-main-layout.wpex-responsive #wrap',
				'alter' => '--wpex-container-width',
				'media_query' => '(min-width: 768px) and (max-width: 959px)',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'tablet_left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content Area Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'default_unit' => '%',
				'placeholder' => '100',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-content-area-width',
				'media_query' => '(min-width: 768px) and (max-width: 959px)',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'tablet_sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'default_unit' => '%',
				'placeholder' => '100%',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-primary-sidebar-width',
				'media_query' => '(min-width: 768px) and (max-width: 959px)',
				'sanitize' => 'container_width',
			),
		),
	),
);

// Mobile Phone Widths
$this->sections['wpex_layout_phone_widths'] = array(
	'title' => esc_html__( 'Mobile Phone Widths', 'total' ),
	'panel' => 'wpex_layout',
	'settings' => array(
		array(
			'id' => 'mobile_landscape_main_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Landscape: Main Container Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'placeholder' => esc_html__( 'inherit from max-width', 'total' ),
				'description' => '(min-width: 480px) and (max-width: 767px)',
			),
			'inline_css' => array(
				'target' => ':root,.boxed-main-layout.wpex-responsive #wrap',
				'alter' => '--wpex-container-width',
				'media_query' => '(min-width: 480px) and (max-width: 767px)',
				'sanitize' => 'container_width',
			),
		),
		array(
			'id' => 'mobile_portrait_main_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Portrait: Main Container Width', 'total' ),
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'placeholder' => esc_html__( 'inherit from max-width', 'total' ),
				'description' => '(max-width: 767px)',
			),
			'inline_css' => array(
				'target' => ':root,.boxed-main-layout.wpex-responsive #wrap',
				'alter' => '--wpex-container-width',
				'media_query' => '(max-width: 767px)',
				'sanitize' => 'container_width',
			),
		),
	),
);