<?php
namespace TotalTheme\Filters;

defined( 'ABSPATH' ) || exit;

/**
 * Comment Author Changes.
 *
 * @package TotalTheme
 * @subpackage Filters
 * @version 5.4
 */
final class Get_Comment_Author {

	/**
	 * Callback method.
	 */
	public static function callback( $author, $comment_id ) {
		if ( ! is_admin() && get_theme_mod( 'bypostauthor_highlight' ) ) {
			$post = get_post();
			$comment = get_comment( $comment_id );
			if ( ! $comment || ! $post ) {
				return $author;
			}
			$supported_types = array( 'post' );
			$supported_types = apply_filters( 'wpex_comment_author_badge_supported_post_types', $supported_types );
			if ( $comment->user_id === $post->post_author && in_array( $post->post_type, $supported_types ) ) {
				$author .= '<span class="wpex-badge wpex-ml-5">' . esc_html__( 'Author', 'total' ) . '</span>';
			}
		}
		return $author;
	}

}