<?php
namespace TotalTheme\Filters;

defined( 'ABSPATH' ) || exit;

/**
 * Hooks into "wp_get_attachment_url".
 *
 * @package TotalTheme
 * @subpackage Filters
 * @version 5.4
 */
final class WP_Get_Attachment_Url {

	/**
	 * Callback method.
	 */
	public static function callback( $url ) {
		/**
		 * The wp_get_attachment_url() function doesn't distinguish whether a page request arrives via HTTP or HTTPS.
		 * Using wp_get_attachment_url filter, we can fix this to avoid the dreaded mixed content browser warning.
		 *
		 * @todo revise if this is still needed.
		 */
		if ( is_ssl() ) {
			$upload_info = wp_upload_dir();
			if ( isset( $upload_info[ 'baseurl' ] ) && strpos( $upload_info[ 'baseurl' ], 'https' ) ) {
				$http  = site_url( FALSE, 'http' );
				$https = site_url( FALSE, 'https' );
				return str_replace( $http, $https, $url );
			}
		}

		return $url;
	}

}