<?php
namespace TotalTheme\Header;

use TotalTheme\Header\Core as Header;

defined( 'ABSPATH' ) || exit;

/**
 * Header Menu.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.4.3
 *
 * @todo move all standard functions from inc/functions/frontend/header-menu.php to this class.
 */
class Menu {

	/**
	 * Checks if the header menu has flush dropdowns (aka full height menu items).
	 */
	public static function has_flush_dropdowns() {
		$check                   = false;
		$supported_header_styles = array( 'one', 'seven', 'eight', 'nine', 'ten' );

		if ( get_theme_mod( 'menu_flush_dropdowns' ) && in_array( Header::style(), $supported_header_styles ) ) {
			$check = true;
		}

		/**
		 * Filters if the header menu has flush dropdowns.
		 *
		 * @param boolean $check
		 */
		$check = (bool) apply_filters( 'wpex_has_header_menu_flush_dropdowns', $check );

		return (bool) $check;
	}

}