<?php
namespace TotalTheme\Integration\Gutenberg;

defined( 'ABSPATH' ) || exit;

/**
 * Registers color palette for the Gutenberg editor.
 *
 * @package TotalTheme
 * @subpackage Integration\Gutenberg
 * @version 5.4
 */
class Editor_Color_Palette {

	/**
	 * Get color palette.
	 */
	public static function get_color_palette() {
		if ( function_exists( 'wpex_get_color_palette' ) ) {
			return wpex_get_color_palette();
		}
	}

	/**
	 * Register colors with the Gutenberg editor.
	 */
	public static function register_colors() {
		$color_palette = (array) self::get_color_palette();

		if ( empty( $color_palette ) ) {
			return;
		}

		$editor_palette = array();

		foreach ( $color_palette as $slug => $color ) {
			$editor_palette[] = array(
				'name'  => $color['name'],
				'slug'  => $slug,
				'color' => $color['color'],
			);
		}

		add_theme_support( 'editor-color-palette', $editor_palette );
	}

}