<?php
namespace TotalTheme\Integration\Gutenberg;

defined( 'ABSPATH' ) || exit;

/**
 * Removes Gutenberg Scripts.
 *
 * @package TotalTheme
 * @subpackage Integration\Gutenberg
 * @version 5.4
 */
class Remove_Scripts {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', __CLASS__ . '::run', 100 );

		// Remove actions.
		self::remove_actions();
	}

	/**
	 * Hooks into wp_enqueue_scripts to remove scripts.
	 */
	public static function run() {

		// removes theme.json and default inline css variables
		wp_dequeue_style( 'global-styles' );

		// Remove core block library.
		wp_dequeue_style( 'wp-block-library' );
		wp_dequeue_style( 'wp-block-library-theme' );

		// Remove WooCommerce scripts.
		if ( WPEX_WOOCOMMERCE_ACTIVE ) {
			wp_dequeue_style( 'wp-block-library' );
			wp_dequeue_style( 'wp-block-library-theme' );
			wp_dequeue_style( 'wc-block-style' );
			wp_dequeue_style( 'wc-blocks-style' ); // "s" was added in a Woo update.
			wp_dequeue_style( 'wc-blocks-vendors-style' );
		}

	}

	/**
	 * Removes actions that insert extra junk to the site.
	 *
	 * @todo update code once WP updates to add proper filter.
	 */
	public static function remove_actions() {

		// remove SVG and global styles
		remove_action( 'wp_body_open', 'wp_global_styles_render_svg_filters' );
		remove_action( 'wp_enqueue_scripts', 'wp_enqueue_global_styles' );

		// remove wp_footer actions which add's global inline styles
		remove_action( 'wp_footer', 'wp_enqueue_global_styles', 1 );

		// remove render_block filters which add unnecessary stuff.
		remove_filter( 'render_block', 'wp_render_duotone_support' );
		remove_filter( 'render_block', 'wp_restore_group_inner_container' );
		remove_filter( 'render_block', 'wp_render_layout_support_flag' );

	}

}